
#include <stdio.h>
#include <stdlib.h>

#define MAXN 1000
#define MAXM 1000
#define MAXNM 1000*1000

struct cell
{
  int elem;
  struct cell* link;
};

int n, m;
int Pl[MAXNM+2];
int Poz[MAXN+1][MAXN+1];
struct cell* G[2][MAXN + 1];
struct cell* G0[2][MAXN + 1];
int fromp, top, freep;
int Nmove;
int ispis[100000][2];

void ReadIn()
{
  int i, j, x;
  struct cell* node;

  scanf ( "%d%d", &n, &m );
  for ( i = 1; i <= MAXN; ++i )
    G[0][i] = G[1][i] = NULL;

  for ( i = 1; i <= n * m; ++i ) Pl[i] = 0;
  for ( i = 1; i <= n; ++i )
    for ( j = 1; j <= m; ++j )
      Poz[i][j] = 0;

  for ( i = 1; i <= n * m; ++i )
  {
    scanf ( "%d", &x );
    j = (i - 1) / m + 1;
    if ( Poz[j][x] == 0 )
      Poz[j][x] = i;
    else
    {
      node = (struct cell *) malloc ( sizeof (struct cell) );
      Pl[i] = Poz[j][x];
      Poz[j][x] = i;
      node->elem = x;
      node->link = G[1][j];
      G[1][j] = node;
    }
  }

  for ( i = 1; i <= n; ++i )
    for ( j = 1; j <= m; ++j )
      if ( Poz[i][j] == 0 )
      {
        node = (struct cell *) malloc ( sizeof (struct cell) );
        node->elem = i;
        node->link = G[0][j];
        G[0][j] = node;
      }
}

int FromRez ( int v, int t )
{
  int p = Poz[v][t];

  Poz[v][t] = Pl[p];
  return p;
}

void dfs ( char t, int pre, int p, char domove )
{
  int q;

  while ( G[t][p] != NULL )
  {
    q = G[t][p]->elem;
    G[t][p] = G[t][p]->link;
    dfs ( 1 - t, p, q, domove );
  }

  if ( domove && !t )
  {
    fromp = FromRez ( pre, p );
    ispis[Nmove][0] = fromp;
    ispis[Nmove][1] = top;
    Nmove++;
    top = fromp;
  }
}

int main ( void )
{
  int i, j;

  Nmove = 0;
  ReadIn();
  for ( i = 0; i < 2; ++i )
    for ( j = 1; j <= MAXN; ++j )
      G0[i][j] = G[i][j];

  for ( i = 1; i <= n; ++i )
    if ( G[1][i] )
      dfs ( 1, G[1][i]->elem, i, 0 );

  for ( i = 0; i < 2; ++i )
    for ( j = 1; j <= MAXN; ++j )
      G[i][j] = G0[i][j];

  freep = n * m + 1;
  for ( i = 1; i <= n; ++i )
    if ( G[1][i] )
    {
      top = freep;
      dfs ( 1, G[1][i]->elem, i, 1 );
      ispis[Nmove][0] = freep;
      ispis[Nmove][1] = fromp;
      Nmove++;
    }
  printf ( "%d\n", Nmove );
  for ( i = 0; i < Nmove; ++i )
    printf ( "%d %d\n", ispis[i][0], ispis[i][1] );

  return 0;
}
