
Program fence;
uses lookup;
Const
	MaxN=100000; {max # posts}
Type
	PointType=record
		left:boolean; {post is on the left side of the road}
		cross:boolean; {segment (i,i+1) crosses the road line}
	end;
Var
	N:longint; {number of the posts}
	P:Array[1..MaxN] of PointType;
	i,i1:longint;
	side:boolean;
	ti,ti1:integer;
	leftpart:longint;
	leftmost:longint;
	iend:longint;
	d:integer;
	m:longint;

Function OnLeft(i,j:longint):boolean;
	{Returns true iff the intersection of the segment (i,i+1) is closer to the road
	endpoint "a" than the intercetion of the segment (j,j+1)}
var
	i1,j1:longint;
begin
	if i=n then i1:=1 else i1:=i+1;
	if j=n then j1:=1 else j1:=j+1;
	OnLeft:=(P[i1].left and(Drift(i,i1,j)<=0)and(Drift(i,i1,j1)<=0)) or
	(P[i].left and (Drift(i,i1,j)>=0)and(Drift(i,i1,j1)>=0)) or
	(P[j1].left and(Drift(j,j1,i)>=0)and(Drift(j,j1,i1)>=0)) or
	(P[j].left and (Drift(j,j1,i)<=0)and(Drift(j,j1,i1)<=0))

end {OnLeft};

Begin {Prog}
	n:=GetN;
	m:=0; {number of intersections with the road line}
	leftmost:=0;{the leftmost intersecting segment}
	for i:=1 to n do begin
		if i=n then i1:=1 else i1:=i+1;
		ti:=Drift(n+1,n+2,i);
		ti1:=Drift(n+1,n+2,i1);
		if ti*ti1<0 then begin {segment (i,i1) intersects with the road line}
			inc(m);
			P[i].cross:=true;
			P[i].left:=ti>0;
			if leftmost=0 then
				leftmost:=i
			else begin
				if OnLeft(i,leftmost) then
				leftmost:=i;
			end;
		end else begin
			P[i].cross:=false;
			P[i].left:=ti>0;
		end;
	end {for i};

	if m=0 then begin
		if P[1].left then
			Answer(1, 0)
		else
			Answer(0, 1)
	end;

	side:=true; {left side of the road}
	i:=leftmost;
	if P[leftmost].left then d:=-1 else d:=1;
	leftpart:=0; {number of regions on the left side}

	repeat

		iend:=i;
		repeat {get the next crossing segment}
			iend:=iend+d;
			if iend>n then iend:=1;
			if iend<1 then iend:=n;
		until P[iend].cross;

		if side and OnLeft(i, iend) then {odd level fence section on the left side}
			inc(leftpart);
		i:=iend;
		side:=not side;

	until i=leftmost;

	Answer(leftpart, m div 2 +1-leftpart)

End.
