unit lookup;
interface
  function Drift(x,y,z:longint):Integer;
  function GetN:longint;
  procedure Answer(left,right:longint);
implementation
Const
  MaxN=100000;
  Init:boolean=true;
Type
  PointType=record
              x,y:longint;
            end;
Var
  N:longint;
  P:Array[0..maxN+2] of PointType;
  A,B:PointType;

procedure ReadIn;
var inFile:Text;
  x,y,i:longint;
begin
  assign(inFile,'fence.in');
  {$I-}
  reset(inFile);
  {$I-}
  if Ioresult<>0 then begin
    writeln('ERROR: input file fence.in not found');
  end;
  readln(inFile,A.x,A.y, B.x,B.y);
  readln(inFile,N);
  For i:=1 To N Do Begin
    ReadLn(inFile, x,y);
    P[i].x:=x; P[i].y:=y;
  End {for i};
  P[n+1]:=A; P[n+2]:=B;
  close(inFile);
  Init:=false;
end {Readin};

Function Drift(x,y,z:longint):Integer;
 {Returns: +1 if x->y->z turns left,
            0 if x,y and z are collinear,
           -1 if x->y->z turns right}
Var
  crosspr:longint;
Begin {Drift}
  if Init then ReadIn;
  if (x<1)or(y<1)or(z<1)or(x>n+2)or(y>n+2)or(z>n+2) then begin
    writeln('ERROR: Illegal argument of Drift');
    Halt(1);
  end;
  crosspr:=(P[y].x-P[x].x)*(P[z].y-P[x].y)-
           (P[z].x-P[x].x)*(P[y].y-P[x].y);
  If (crosspr < 0) Then
    Drift:=-1
  Else If crosspr>0 Then
    Drift:=1
  Else
    Drift:=0;
End {Drift};

function GetN:longint;
begin
  if not Init then begin
    ReadIn;
    Init:=false;
  end;
  GetN:=N;
end;
procedure Answer(left,right:longint);
var
  outFile:Text;
begin
  if Init then begin
    writeln('ERROR: You must call GetN first');
    Halt(1);
  end;
  assign(outFile,'fence.out'); rewrite(outFile);
  writeln(outFile, left,' ',right);
  close(outFile);
  Halt;
end;

begin
  ReadIn;
end.
