{ Model solution for task HOT
  Author: Miroslaw Michalski
  Time complexity : O(n log n)
  22MAY11
}
const MAXN = 500123;

type
pair = record
    first : longint;
    second : longint;
    end;
triple = record
    first : pair;
    second : longint;
    end;

table = array[0..MAXN] of longint;
pairtable = array[0..MAXN] of pair;
tripletable = array[0..MAXN] of triple;

var q, vtmp : pairtable;
    fau : tripletable;
    think : table;
    p : table;
    be, en, mid, realMidPos, realBePos : longint;
    thinkSize, fauSize, cnt, n, m, o, i, c_i, p_i : longint;
    target, prev, par : pair;
    offer, obj, tri : triple;
    res : int64;

function min(x, y : longint) : longint;
  begin
    min := y;
    if (x < y) then min := x;
  end;

procedure qsortpair(l, r : longint; var t : pairtable);
  procedure sort(l,r: longint);
  var
   i,j: longint;
   x, y : pair;
  begin
    i:=l; j:=r; x:=t[(l+r) div 2];
    repeat
      while (t[i].first < x.first) or ((t[i].first = x.first) and (t[i].second < x.second)) do inc(i);
      while (x.first < t[j].first) or ((t[j].first = x.first) and (x.second < t[j].second)) do dec(j);
      if not(i>j) then
        begin 
          y:=t[i]; t[i]:=t[j]; t[j]:=y; inc(i); dec(j);
        end;
    until i>j;
    if l<j then sort(l,j);
    if i<r then sort(i,r);
  end;
  
  begin
   if (l < r) then sort(l, r);
  end;


procedure qsort(l, r : longint; var t : table);
  procedure sort(l,r: longint);
  var
   i,j, x, y: longint;
  begin
    i:=l; j:=r; x:=t[(l+r) div 2];
    repeat
      while (t[i] < x) do inc(i);
      while (x < t[j]) do dec(j);
      if not(i>j) then
        begin 
          y:=t[i]; t[i]:=t[j]; t[j]:=y; inc(i); dec(j);
        end;
    until i>j;
    if l<j then sort(l,j);
    if i<r then sort(i,r);
  end;
  
  begin
  if (l < r) then sort(l, r);
  end;
 
function Find(x : longint): longint;
  begin
    if (p[x] < 0) then
      begin
        Find := x;
      end else
            begin
              p[x] := Find(p[x]);
              Find := p[x];
            end;
  end;

procedure Union(x, y : longint);
  begin
   x := Find(x); y := Find(y);
   if (x <> y) then
    begin
      if (p[x] > p[y]) then
        begin
          p[y] := x;
        end else
          begin
            p[x] := y;
          end;
    end;
  end;

begin
  fauSize := 0;
  thinkSize := 0;
  res := 0;
  for i := 0 to MAXN do 
    begin
      p[i] := -1;
    end;
  readln(n, m, o);
  for i := 0 to n - 1 do
    begin
      readln(c_i, p_i);
      par.first := p_i;
      par.second := c_i;
      vtmp[i] := par;
    end;
  qsortpair(0, n - 1, vtmp);
  prev := vtmp[0];
  cnt := 1;
  for i := 1 to n - 1 do
    begin
      if (vtmp[i].first <> prev.first) or (vtmp[i].second <> prev.second) then
        begin
          inc(fauSize);
          tri.first := prev;
          tri.second := cnt;
          fau[fauSize - 1] := tri;
          prev := vtmp[i];
          cnt := 1;
        end else 
          begin
            inc(cnt);
          end;
    end;
    inc(fauSize);
    tri.first := prev;
    tri.second := cnt;
    fau[fauSize - 1] := tri;
    
    for i := 0 to m - 1 do 
      begin
        readln(c_i, p_i);
        par.first := c_i;
        par.second := p_i;
        q[i] := par;
      end;
  
    qsortpair(0, m - 1, q);
    for i := 0 to m div 2 - 1 do
      begin
        par := q[i]; q[i] := q[m - i - 1]; q[m - i - 1] := par;
      end;

    for i := 0 to m - 1 do
      begin
      c_i := q[i].first;
      p_i := q[i].second;
      target.first := p_i;
      target.second := -1;
      be := 0; en := fauSize - 1;
      while (be < en) do
        begin
          mid := be + (en - be) div 2;
          realMidPos := Find(mid);
          obj := fau[realMidPos];
          if (obj.first.first < target.first) or 
             ((obj.first.first = target.first) and (obj.first.second < target.second)) then
            begin
              be := mid + 1;
            end else
              begin
                en := mid;
              end;
        end;
      realBePos := Find(be);
      offer := fau[realBePos];
      if (offer.second > 0) and 
        ((offer.first.first > target.first) or 
         ((offer.first.first = target.first) and (offer.first.second > target.second))) then
        begin
          if (offer.first.second < c_i) then
            begin
              inc(thinkSize);
              think[thinkSize - 1] := c_i - offer.first.second;
              if (offer.second = 1) then
                begin
                  fau[realBePos].second := 0;
                  if (realBePos < fauSize - 1) then
                    begin
                      Union(realBePos, realBePos + 1);
                    end else
                      begin
                        dec(fauSize);
                      end;
                end else 
                  begin
                    dec(fau[realBePos].second);
                  end;
              end;
            end;
        end;
    qsort(0, thinkSize - 1, think);
    o := min(o, thinkSize);
    for i := 1 to o do
      begin
        res := res + think[thinkSize - i];
      end;

    writeln(res);
end.


