/* Alternative solution for task HOT
 * Author: Mateusz Baranowski
 * Time complexity: O((n+m) log(nm))
 */

#include <cstdio>
#include <queue>
#include <algorithm>
#include <vector>
using namespace std;

#define INFTY 1000000001

int n, m, o, x, y;
vector< pair<int, int> > room, offer;
vector<int> next;
priority_queue<int> q;

int get_next(int x) {
  if (x != next[x]) next[x] = get_next(next[x]);
  return next[x];
}

int main() {
  scanf ("%d %d %d", &n, &m, &o);
  for (int i = 0; i < n; ++i) {
    scanf ("%d %d", &x, &y);
    room.push_back(make_pair(y, x));
    next.push_back(i);
  }
  next.push_back(n);
  room.push_back(make_pair(INFTY, INFTY));
  sort(room.begin(), room.end());
  for (int i = 0; i < m; ++i) {
    scanf ("%d %d", &x, &y);
    offer.push_back(make_pair(x, y));
  }
  sort(offer.begin(), offer.end());
  for (int i = m-1; i >= 0; --i) {
    y = offer[i].second;
    int a = 0, b = n;
    while (a < b) {
      int c = (a + b)/2;
      if (room[c].first < y) a = c + 1; else b = c;
    }
    y = get_next(a);
    if (y < n) {
      next[y] = y+1;
      q.push(offer[i].first - room[y].second);
    }
  }
  long long result = 0;
  while (o-- > 0 && !q.empty() && (x = q.top()) > 0) {
    result += x;
    q.pop();
  }
  printf ("%lld\n", result);
  return 0;
}
