(* Alternative solution for task HOT
 * Author: Mateusz Baranowski
 * Time complexity: O((n+m) log(nm))
 *)

const
  INFTY = 1000000001;
  MAXN = 500001;

type
  pair_t = record
    first, second : longint;
  end;

var
  v_size, a, b, c, i : longint;
  n, m, o, x, y : longint;
  room, offer : array[0..MAXN] of pair_t;
  next : array[0..MAXN] of longint;
  values : array[0..MAXN] of pair_t;
  tab : array[0..MAXN] of pair_t;
  total_result : int64;

procedure merge_sort(l, r : longint; var tab1: array of pair_t);
var
  m, a, b, c, i : longint;
begin
  m := l + (r - l + 1) div 2;
  if r = l + 1 then exit;
  merge_sort(l, m, tab1);
  merge_sort(m, r, tab1);
  a := l;  b := m;  c := 0;
  while (a < m) or (b < r) do
  begin
    if (a < m) and
      ((b = r) or
        ((tab1[a].first < tab1[b].first) or
          ((tab1[a].first = tab1[b].first) and (tab1[a].second < tab1[b].second)))) then
    begin
      tab[c] := tab1[a];
      a := a + 1;
    end else begin
      tab[c] := tab1[b];
      b := b + 1;
    end;
    c := c + 1;
  end;
  for i := 0 to r-l-1 do tab1[i + l] := tab[i];
end;

function get_next(x : longint) : longint;
begin
  if x <> next[x] then next[x] := get_next(next[x]);
  get_next := next[x];
end;

Begin
  readln(n, m, o);
  for i := 0 to n-1 do
  begin
    readln(x, y);
    room[i].first := y;
    room[i].second := x;
    next[i] := i;
  end;
  next[n] := n;
  room[n].first := INFTY;
  room[n].second := INFTY;
  merge_sort(0, n, room);
  for i := 0 to m-1 do
  begin
    readln(x, y);
    offer[i].first := x;
    offer[i].second := y;
  end;
  merge_sort(0, m, offer);
  v_size := 0;
  for i := m-1 downto 0 do
  begin
    y := offer[i].second;
    a := 0; b := n;
    while a < b do
    begin
      c := (a + b) div 2;
      if room[c].first < y then a := c + 1 else b := c;
    end;
    y := get_next(a);
    if y < n then
    begin
      next[y] := y+1;
      values[v_size].first := offer[i].first - room[y].second;
      v_size := v_size + 1;
    end;
  end;
  merge_sort(0, v_size, values);
  total_result := 0;
  i := 0;
  while (v_size - i > 0) and (o > 0) and (values[v_size - i - 1].first > 0) do
  begin
    i := i + 1;
    o := o - 1;
    total_result := total_result + values[v_size - i].first;
  end;
  writeln(total_result);
End.
