
const Max_n = 10000; {* max number of vertices *}

{* Solution: Let us define a polygon graph as the graph in which
   two verices are joined if they are ends of the same side or diagonal.
   Such a graph has only one Hamiltonian cycle and our goal is to find this
   cycle. We proceed as follows:
   1. Identify sides of the polygon.
   2. Build the subgraph spanned on the sides - this is the required cycle.
   3. Find proper order of the vertices on the cycle.

   The only hard steps are 1 and 2. In order to identify sides of the polygon
   we apply Depth First Search computing the dfs_numbering and the function
   low defined on the vertices in the following way
   (this is the same function as in the the
   famous algorithm for computing biconnected components):

    low[v] = min(<dfs_nr[v]> + <low[w]: w son of v in dfs tree> +
                  <dfs_nr[w]: w is ancector of v in dfs tree diffrent from
		              its parent>)

   (Note: '+' means sum of sets.)

   Both the function low and dfs_numbering can be computind during
   the one run of the depth first search.
   Applying these two functions we can classify
   the edges of the graph as follows.

   Let us consider a dfs-tree edge u---v, where u is the paren of v.
   There are several cases:
   1. vertex v has no children -- it means that u--v is a side of the polygon;
      among the other edges incident to v the edge going to the vertex with
      the smallest dfs_number corresponds to the another side incident to v.
   2. vertex v has 1 child -- unfortunately there are 2 subcases
      2.1 parent of v is the root of the tree: u--v is a side
          of the polygon; the other sides incident to u or v have been already
	  found
      2.2 u is not the root of the tree, let w be the only child of v:
          if low[w] < dfs_nr[u] then u--v is a side of the polygon, the other
	  side incident to v has been already found;
	  if low[w] >= dfs_nr[u] then u--v is a diagonal; let x be
	  the ancestor of v for which the value low[x] is the smallest one;
	  v--x is a side of the polygon, the other side incident to v
	  has been already found.


   Running time - linear.
*}

type
  P_list_el = ^list_el;
  list_el = record
    vert : 1..Max_n;
    next : P_list_el
  end;

  Adj_lists = array[1..Max_n] of P_list_el; {* adjacency lists *}

  Two_vertices = array[1..2] of 0..Max_n; {* beginning and end of a side or
                                          a diagonal *}

  Neighbours = array [1..Max_n] of Two_vertices; {* for each vertex
                                                    its neighbours on the border
                                                    of the polygon *}

  Integer_array = array [1..Max_n] of integer;

procedure Build_Polygon_Graph(var L : Adj_lists; var n : integer);
{* building adjacency lists of the input polygon graph;
   n - nr of vertices; *}
var
  m, i : integer;
  p : P_list_el;
  v, w : 1..Max_n;
begin
  readln(n, m);
  m := m+n;

  for i := 1 to n do
    L[i] := nil;

  for i := 1 to m do
  begin
    read(v,w);
    new(p); p^.vert := w; p^.next := L[v]; L[v] := p;
    new(p); p^.vert := v; p^.next := L[w]; L[w] := p
  end
end;

procedure Build_Array_of_Neighbours(var L : Adj_lists; var n : integer;
                                    var Neigh : Neighbours);
{* for each vertex its neighbours on the border of the polygon are being found;
   this gives double, cyclic linked list of the polygon vertices -- neighbours
   are linked together *}

var
  dfs_nr, low : Integer_array; {*global variables for Depth First Search*}
  last : integer;


  procedure DFS(v, parent_v : integer);
  var
    p : P_list_el;
    nr_of_children : 0..2;
    child : integer;
    low_vert : integer; {* neighbour of v with the smallest low *}
  begin
    inc(last);
    dfs_nr[v] := last; low[v] := last; low_vert := v;
    p := L[v];
    nr_of_children := 0;
    while p <> NIL do
    begin
      if dfs_nr[p^.vert] = 0 then
      begin
        inc(nr_of_children);
        child := p^.vert;
        DFS(p^.vert,v);
        if low[p^.vert] < low[v] then
        begin
          low[v] := low[p^.vert];
          low_vert := p^.vert
        end;
      end
      else
        if p^.vert <> parent_v then
          if dfs_nr[p^.vert] < low[v] then
          begin
            low[v] := dfs_nr[p^.vert];
            low_vert := p^.vert
          end;
      p := p^.next
    end;

    case nr_of_children of
        0 : begin
              Neigh[v][1] := parent_v;
              if Neigh[parent_v][1] = 0 then
                Neigh[parent_v][1] := v
              else
                Neigh[parent_v][2] := v;

              Neigh[v][2] := low_vert;
              if Neigh[low_vert][1] = 0 then
                Neigh[low_vert][1] := v
              else
                Neigh[low_vert][2] := v
            end;
        1 : if v <> 1 then
            begin
              if parent_v = 1 {root} then
              begin
                Neigh[v][2] := 1;
                Neigh[1][2] := v
              end
              else
                if low[child] < dfs_nr[parent_v] then
                begin
                  Neigh[v][2] := parent_v;
                  if Neigh[parent_v][1] = 0 then
                     Neigh[parent_v][1] := v
                  else
                     Neigh[parent_v][2] := v
                end else
                begin
                  Neigh[v][2] := low_vert;
                  if Neigh[low_vert][1] = 0 then
                     Neigh[low_vert][1] := v
                  else
                     Neigh[low_vert][2] := v
                end
            end
    end
  end;

var
  i : integer;

begin
  for i := 1 to n do
  begin
    dfs_nr[i] := 0;
    Neigh[i][1] := 0;
    Neigh[i][2] := 0
  end;

  last := 0;
  DFS(1,0)
end;

procedure Result(var Neigh : Neighbours; n : integer);
var
  i, j : integer;
begin
  i := 1; j := 1; write(1);
  if Neigh[1][1] < Neigh[1][2] then
    i := Neigh[1][1]
  else
    i := Neigh[1][2];


  while n > 1 do
  begin
    if Neigh[i][1] <> j then
    begin
      j := i;
      i := Neigh[i][1]
    end
    else
    begin
      j := i;
      i := Neigh[i][2]
    end;
    write(' ',j);
    dec(n)
  end;
  writeln
end;

var
  n : integer;
  L : Adj_lists;
  Neigh : Neighbours;
  d, i : integer;
begin
  readln(d);
  for i := 1 to d do
  begin
    Build_Polygon_Graph(L,n);
    Build_Array_of_Neighbours(L, n, Neigh);
    Result(Neigh,n)
  end
end.
