
/* proposed by Luis Lopes,
   Computer Science Department, University of Porto

   Idea for the solution:

   1. find how many days there are in a Calendar Round:

      365 days from Haab;  260 days from Tzolkin

      The combined cycle, the Long Count, has a periodicity of

      260*365/5 (or 52*365)
      since 5 is the only common factor between 260 and 365

   2. Find the 1st occurrence of a given calendar round date (the input)
      starting from the long count 8.0.0.0.0 and knowing that it
      corresponds to 9.Ajaw 3.Sip:


      lg0= 8.0.0.0.0
      cr0= (9.19,3.2)

      crIN= inputvalue;
      days=0;
      flag=false;

      while (!flag && days < 52*365) {
        incr_calendarround(cr0);
        incr_longcount(lg0,1);
        if (cr0==crIN)
	  flag=true
      }
      if (flag==false)
        print IMPOSSIBLE
      else  {
         "to find all sols. one has to advance 52*365 days at a time,
	 starting at current value of lg0; it stops when baktun(lg0)=10"
        while (baktun(lg0)!=10) {
          print(lg0);
          incr_longcount(lg0,52*365);
        }
      }
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Haab months
static char  haabMonths[][16] = {
  "Pohp", "Wo", "Sip", "Zotz", "Sek", "Xul",
  "Yaxkin", "Mol", "Chen", "Yax", "Sak", "Keh",
  "Mak", "Kankin", "Muan", "Pax", "Kayab", "Kumku", "Wayeb"
};

// Tzolk'in days
static char  tzolkinDays[][16] = {
  "Imix", "Ik", "Akbal", "Kan", "Chikchan", "Kimi",
  "Manik", "Lamat", "Muluk", "Ok", "Chuen", "Eb",
  "Ben", "Ix", "Men", "Kib", "Kaban", "Etznab", "Kawak", "Ajaw"
};

typedef enum{false=0,true=1} bool;

long baktun, katun, tun, uinal, kin;
long dayCoef, monthCoef;
long dayName, monthName;

long inputDayCoef, inputDayName;
long inputMonthCoef, inputMonthName;
char inputDayNameString[16], inputMonthNameString[16];

void decodeNames();
bool dateMatches();
void printLongCountDate();
void addDistanceNumber();

#define MAX_RES 100

struct lcDate {
  int baktun;
  int katun;
  int tun;
  int uinal;
  int kin;
} res[MAX_RES]; // stores results
int noOfRes;

/**
 * 0.2.12.13.0 = 18980 days
 * the period of the Calendar Round cycle
 */

int main( int argc, char *argv[] ) {
  int numberOfDays;
  int numberOfCases;
  int nCase, i;

 scanf("%d", &numberOfCases);
 for(nCase=1; nCase <= numberOfCases; nCase++) {

  /**
   * initialize the Long Count and Calendar Round dates
   */
  baktun      = 8;
  katun       = 0;
  tun         = 0;
  uinal       = 0;
  kin         = 0;
  dayCoef     = 9;   /* 9 Ajaw */
  dayName     = 19;
  monthCoef   = 3;   /* 3 Sip  */
  monthName   = 2;

  /**
   * get the input Calendar Round
   */
  scanf("%ld %s %ld %s",&inputDayCoef,inputDayNameString,&inputMonthCoef,inputMonthNameString);
  decodeNames();
  /**
   * find the first Long Count which matches the
   * Calendar Round date
   */
  numberOfDays = 0;
  while( numberOfDays < 18980 ) {
     if( dateMatches() )
        break;
     addDistanceNumber( 0, 0, 0, 0, 1 );
     numberOfDays++;
  }
  if( numberOfDays == 18980 ) {
     printf("0\n");
  }
  else {
     /**
      * print all successive dates until baktun 10
      */
     noOfRes = 0;
     do {
        // printLongCountDate();
	res[noOfRes].baktun = baktun;
	res[noOfRes].katun = katun;
	res[noOfRes].tun = tun;
	res[noOfRes].uinal = uinal;
	res[noOfRes].kin = kin;
	noOfRes++;
        addDistanceNumber( 0, 2, 12, 13, 0 );

     } while( baktun < 10 );
     printf("%d\n", noOfRes);
     for(i = 0; i < noOfRes; i++)
       printLongCountDate(res[i]);
  }
 }
 return 0;
}

void decodeNames() {
  int i = 0, j = 0;
  while (i < 20 && strcmp (inputDayNameString, tzolkinDays[i]) != 0)
     i++;
  if (i == 20) {
    printf("Day %s not found\n", inputDayNameString);
    exit(1);
  }
  while (j < 19 && strcmp (inputMonthNameString, haabMonths[j]) != 0)
     j++;
  if (j == 19) {
    printf("Month %s not found\n", inputMonthNameString);
    exit(1);
  }
  inputDayName   = i;
  inputMonthName = j;
}

bool dateMatches() {
  if ( dayCoef   == inputDayCoef   && dayName   == inputDayName &&
       monthCoef == inputMonthCoef && monthName == inputMonthName )
     return true;
  else
     return false;
}
void addDistanceNumber (long x, long y, long z, long u, long v) {
  long carry = 0;

  kin   = kin + v;
  carry = kin / 20;
  kin   = kin % 20;

  uinal = uinal + u + carry;
  carry = uinal / 18;
  uinal = uinal % 18;

  tun   = tun + z + carry;
  carry = tun / 20;
  tun   = tun % 20;

  katun = katun + y + carry;
  carry = katun / 20;
  katun = katun % 20;

  baktun= baktun + x + carry;
  carry = baktun / 20;
  baktun= baktun % 20;

  monthCoef = (monthCoef) % (monthName == 18 ? 5:20) + 1;
  if( monthCoef == 1 )
     monthName = (monthName + 1) % 19;

  dayCoef   = (dayCoef ) % 13 + 1;
  dayName   = (dayName + 1) % 20;
}


void printLongCountDate(struct lcDate lc) {
   printf("%d.%d.%d.%d.%d\n", lc.baktun, lc.katun, lc.tun, lc.uinal, lc.kin);
}
