
{* Solution:
     During the execution of a given CE-program each register
     is in one of three stages 0,1,2:
     0: no more CE-instructions are needed with this register
        as the second parameter to make the program reliable;
     1:	1 more CE-instruction is needed;
     2: 2 more CE-instructions are needed.

   The only problem is to change the states properly.
   See the program below.

   The number of necessary new instructions is equal to the
   sum of register states.

   Running time: linear
*}

const
  Max_n = 10000; {* bound on the number of registers *}

type
  states = array [1..Max_n] of 0..2; {* register states *}

var
  d : integer; {* number of data sets *}
  n, m : integer; {* number of registers, number of instructions *}
  reg_states : states; {* register states *}
  i, j, a, b : longint; {* auxiliary variables *}
begin
  readln(d);

  for i := 1 to d do begin
  {* the i'th set of data*}

    readln(n, m);

    {* initialization of the register states *}
    reg_states[1] := 0;
    for j := 2 to n do
      reg_states[j] := 2;

    {* reading subsequent instructions and changing states of registers *}
    for j := 1 to m do begin
      read(a, b);
      if a = 1 then begin
        if reg_states[b] > 0 then
          reg_states[b] := reg_states[b] - 1
      end
      else
        case reg_states[a] of
          0,1 : if reg_states[b] > 0 then begin
                  reg_states[a] := reg_states[b];
                  reg_states[b] := reg_states[b] - 1
                end;
          2   : if reg_states[b] > 0 then
                  reg_states[b] := reg_states[b] - 1
        end
    end;
    readln;

    {* computing the results *}
    a := 0;
    for j := 2 to n do
      a := a + reg_states[j];

    writeln(a)
  end
end.
