
const
  MaxN = 50000;

var
  ddd, dd: Integer;
  n: LongInt;
  X, S : array [1..2 * MaxN] of LongInt;
  b, h, w, d: LongInt;
  vol: LongInt;

procedure Exchange (i, j: LongInt);
var
  pom: LongInt;
begin
  pom := X [i]; X [i] := X [j]; X [j] := pom;
  pom := S [i]; S [i] := S [j]; S [j] := pom;
end;

procedure UpHeap (n : LongInt); {n > 0}
  { before  X [1..n - 1] is a heap ; after X [1..n] is a heap }
var
  i, p : LongInt;
begin
  i := n;
  repeat
    if i = 1 then Break;
    p := i div 2;
    if X [p] >= X [i] then Break;
    Exchange (p, i);
    i := p
  until False
end;

procedure DownHeap (n : LongInt); {n >= 0}
  { before X [2..n] is a heap ; after  X [1..n] is a heap }
var
  i, s : LongInt;
begin
  i := 1;
  repeat
    s := 2 * i;
    if s > n then Break;
    if (s + 1 <= n) and (X [s + 1] > X [s]) then Inc (s);
    if X [i] >= X [s] then Break;
    Exchange (s, i);
    i := s
  until False
end;

procedure HeapSort (n: LongInt);
var
  i: LongInt;
begin
  for i := 2 to n do
    UpHeap (i);
  for i := n downto 2 do
  begin
    Exchange (i, 1);
    DownHeap (i - 1);
  end;

  for i := 1 to n - 1 do
    if X [i] > X [i + 1] then
    begin
      WriteLn ('Error! ', i);
      Halt;
    end;
end;

procedure Count;
var
  i: LongInt;
  w: LongInt;
  res: Double;
begin
  HeapSort (2 * n);

  for i := 1 to 2 * n - 1 do
  begin

    // at heights from X[i] to X[i+1] the cisterns have section S[i]
    w := (X [i + 1] - X [i]) * S [i];

    if w >= vol then
    begin
      if S [i] > 0 then
        res := Double(vol) / Double (S [i]) + Double (X [i])
      else
        res := X [i];
      WriteLn (res : 0 : 2);
      Exit;
    end
    else
      vol := vol - w;

    S [i + 1] := S [i + 1] + S [i];
  end;
  if vol > 0 then
    WriteLn ('OVERFLOW')
  else
    WriteLn (Double (X [2 * n - 1]): 0: 2);
end;

var
  i: LongInt;

begin
  Randomize;
  ReadLn (ddd);
  for dd := 1 to ddd do
  begin
    ReadLn (n);
    for i := 1 to n do
    begin
      ReadLn (b, h, w, d);
      X [i * 2 - 1] := b;
      X [i * 2] := b + h;
      S [i * 2 - 1] := w * d;
      S [i * 2] := -w * d;
    end;
    ReadLn (vol);
    Count;
  end;
end.
