
/* Rjesenje napisali Frane Saric, Matija Kazalicki i Zvonimir Bujanovic */

# include <stdio.h>
# include <algorithm>
# include <map>
# include <set>

using namespace std;

struct line { int x, y1, y2; };

line lines[8001];

struct endpoint
{
	int line;
	bool isStart;
	int y (void) const
	{
		if (isStart) return lines[line].y1;
		return lines[line].y2;
	}
	int x (void) const { return lines[line].x; }
};

endpoint endpoints[16002];

struct endpointscmp
{ bool operator () (const endpoint &a, const endpoint &b) { return a.y () < b.y (); } };

set<int> edges[8002];

int main (void)
{
	int ntst;
	int n, i, j, y, t;
	map<int, int> linetree;

	scanf ("%d", &ntst);
	for (;--ntst >= 0;)
	{
		int nendpoints;

		scanf ("%d", &n);

		nendpoints = 0;
		for (i = 0; i < n; ++i)
		{
			scanf ("%d%d%d", &lines[i].y1, &lines[i].y2, &lines[i].x);
			lines[i].y1 *= 2;
			lines[i].y2 = lines[i].y2 * 2 + 1;
			endpoints[nendpoints].line = i, endpoints[nendpoints].isStart = false, ++nendpoints;
			endpoints[nendpoints].line = i, endpoints[nendpoints].isStart = true, ++nendpoints;
			edges[i].clear ();
		}
		sort (endpoints, endpoints + nendpoints, endpointscmp ());

		linetree.clear ();
		for (i = 0; i < nendpoints;)
		{
			y = endpoints[i].y ();

			for (j = i; i < nendpoints && !endpoints[i].isStart && endpoints[i].y () == y; ++i)
				linetree.erase (endpoints[i].x ());

			for (; j < i; ++j)
			{
				map <int, int>::iterator a, b;

				b = linetree.upper_bound (endpoints[j].x ());
				if (b == linetree.end ()) continue;
				a = b, --a;
				if (a == linetree.end ()) continue;
				if (a == b) continue;
				edges[a -> second].insert (b -> second);
				edges[b -> second].insert (a -> second);
			}

			for (j = i; i < nendpoints && endpoints[i].isStart && endpoints[i].y () == y; ++i)
				linetree[endpoints[i].x ()] = endpoints[i].line;

			for (; j < i; ++j)
			{
				map <int, int>::iterator mit, oldmit;
				t = endpoints[j].line;

				oldmit = mit = linetree.find (endpoints[j].x ());
				--mit;
				for (y = 0; y < 2; ++y, mit = oldmit, ++mit)
					if (mit != linetree.end () && mit -> second != t)
					{
						edges[t].insert (mit -> second);
						edges[mit -> second].insert (t);
					}
			}
		}

		for (i = t = 0; i < n; ++i)
		{
			set<int>::iterator it1, it2;

			for (it1 = edges[i].begin (); it1 != edges[i].end (); ++it1)
				for (it2 = it1; it2 != edges[i].end (); ++it2)
					if (it1 != it2)
						if (edges[*it1].find (*it2) != edges[*it1].end ())
						{
							++t;
							edges[*it1].erase (i);
							edges[*it2].erase (i);
						}
			edges[i].clear ();
		}
		printf ("%d\n", t);
	}
	return 0;
}
