
// DMIH 2001 - Drugi dan natjecanja
// Srednjoskolska skupina - I. podskupina
// Zadatak PIVA
// Autor rjesenja Ante Djerek
// Nesluzbeno rjesenje

#include <stdio.h>

#define INFILE  "piva.in"
#define OUTFILE "piva.out"
#define NDIRS   4
#define MAXBOCA 10

char znak[NDIRS]={'U', 'R', 'D', 'L'};

int n;
int tablica[MAXBOCA][MAXBOCA];

void citaj_ulaz (void)
{
    int i, j, k;
    char c;
    FILE *input;

    input=fopen(INFILE, "r");
    fscanf(input, "%d\n", &n);
    for (i=n-1; i>=0; i--)
    {
        for (j=0; j<n-i; j++)
        {
            fscanf(input, "%c", &c);
            for (k=0; k<NDIRS; k++)
                if (znak[k]==c)
                   tablica[i][j]=k;
        }
        fscanf(input, "\n");
    }
}

int valid (int r, int s)
{
    if (r<0 || r>=n) return 0;
    if (s<0 || s>=n-r) return 0;
    return 1;
}

void okreni (int r, int s)
{
    tablica[r][s]=(tablica[r][s]+1)%NDIRS;
    if (valid(r+1, s-1)) tablica[r+1][s-1]=(tablica[r+1][s-1]-1+NDIRS)%NDIRS;
    if (valid(r+1, s)) tablica[r+1][s]=(tablica[r+1][s]-1+NDIRS)%NDIRS;
}

void rijesi (void)
{
    int i, j;
    FILE *output;

    output=fopen(OUTFILE, "w");
    for (i=0; i<n; i++)
    {
        for (j=0; j<n-i; j++)
            while (tablica[i][j]!=0)
            {
                okreni(i, j);
                fprintf(output,"%d %d\n", i+1, j+1);
            }
    }
    fclose(output);
}


int main (void)
{
    citaj_ulaz();
    rijesi();

    return 0;
}
