
// DMIH 2001 - Prvi dan natjecanja
// Srednjoskolska skupina - II. podskupina
// Zadatak KALK
// Autor rjesenja Ante Djerek
// Nesluzbeno rjesenje

/*
    'on the fly' implementacija, generira rjesenje tokom parsinga

    Izvod(I) = niz naredbi tako da od stoga (B, A, ostatak) dobjem
               (B, A, I, ostatak) s tim da ostatak ostane nepromjenjen

    Izvod definiram rekurzivno po gradnji formule:
       Izvod('A') = SWAP DUP DUP ROT ROT DROP
       Izvod('B') = DUP DUP ROT ROT DROP SWAP
       Izvod('(t$s)') = Izvod(t) Izvod(s) ROT ROT DOLLAR DUP ROT ROT ROT DROP
       Izvod('(t$s)') = Izvod(t) Izvod(s) ROT ROT HASH DUP ROT ROT ROT DROP

    Rjesenje mi je Izvod(I) + ciscenje stoga
       Rjesenje(I) = Izvod(I) DROP DROP
*/

#include <stdio.h>
#include <assert.h>

#define INFILE   "kalk.in"
#define OUTFILE  "kalk.out"
#define MAXCHAR  100
#define ROT      "ROT"
#define SWAP     "SWAP"
#define DUP      "DUP"
#define DROP     "DROP"
#define OP1      "HASH"
#define C1       '#'
#define OP2      "DOLLAR"
#define C2       '$'
#define VARC1    'A'
#define VARC2    'B'


FILE *input, *output;

char ulaz[MAXCHAR+1];
int pos;

void izvedi_A (void)
{
    fprintf(output, "%s\n", SWAP);
    fprintf(output, "%s\n", DUP);
    fprintf(output, "%s\n", DUP);
    fprintf(output, "%s\n", ROT);
    fprintf(output, "%s\n", ROT);
    fprintf(output, "%s\n", DROP);
}

void izvedi_B (void)
{
    fprintf(output, "%s\n", DUP);
    fprintf(output, "%s\n", DUP);
    fprintf(output, "%s\n", ROT);
    fprintf(output, "%s\n", ROT);
    fprintf(output, "%s\n", DROP);
    fprintf(output, "%s\n", SWAP);
}

void izvedi_op (char *opstring)
{
    fprintf(output, "%s\n", ROT);
    fprintf(output, "%s\n", ROT);
    fprintf(output, "%s\n", opstring);
    fprintf(output, "%s\n", DUP);
    fprintf(output, "%s\n", ROT);
    fprintf(output, "%s\n", ROT);
    fprintf(output, "%s\n", ROT);
    fprintf(output, "%s\n", DROP);
}

void ocisti (void)
{
    fprintf(output, "%s\n", DROP);
    fprintf(output, "%s\n", DROP);
}

void parse (void)
{
    char op;

    if (ulaz[pos]=='(')
    {
        pos++;
        parse();
        op=ulaz[pos];
        pos++;
        parse();
        assert(op==C1 || op==C2);
        if (op==C1) izvedi_op(OP1);
        if (op==C2) izvedi_op(OP2);
        assert(ulaz[pos]==')');
        pos++;
        return ;
    }
    assert(ulaz[pos]==VARC1 || ulaz[pos]==VARC2);
    if (ulaz[pos]==VARC1)
       izvedi_A();
    if (ulaz[pos]==VARC2)
       izvedi_B();
    pos++;
}

int main (void)
{
    input=fopen(INFILE, "r");
    output=fopen(OUTFILE, "w");

    fscanf(input, "%s", ulaz);
    pos=0;

    parse();
    ocisti();

    fclose(input);
    fclose(output);

    return 0;
}
