
// DMIH 2001 - Prvi dan natjecanja
// Srednjoskolska skupina - I. podskupina
// Zadatak MASA
// Autor rjesenja Ante Djerek
// Nesluzbeno rjesenje

/*
    Masa - Djerek

    Trazi masu molekule...

    Sintaksa ulaza:
        Ulaz     = Molekula+
        Molekula = Jedinka | "("Molekula+")"[Broj]
        Jedinka  = Atom[Broj]
        Atom     = "C" | "H" | "O"      (mozda treba dodat jos)
        Broj     = "1" | "2" | "3" | ... | "9"
*/

#include <stdio.h>
#include <string.h>

#define INFILE    "masa.in"
#define OUTFILE   "masa.out"
#define MAXLEN    100
#define LPAREN    '('
#define RPAREN    ')'
#define NATOMS    3

const char atom[NATOMS]={'C', 'H', 'O'};
const int  masa[NATOMS]={ 12,  1 ,  16};

char ulaz[MAXLEN+2];
int pos;
int rjesenje;

void citaj_ulaz (void)
{
    char tmp[MAXLEN];
    FILE *input;

    input=fopen(INFILE, "r");
    fscanf(input, "%s", tmp);
    strcpy(ulaz, "(");
    strcat(ulaz, tmp);
    strcat(ulaz, ")");
    fclose(input);
}

void ispisi_rjesenje (void)
{
    FILE *output;

    output=fopen(OUTFILE, "w");
    fprintf(output, "%d\n", rjesenje);
    fclose(output);
}

int izracunaj (void)
{
    int sum, i;

    if (ulaz[pos]==LPAREN)
    {
        sum=0;
        pos++;
        while (ulaz[pos]!=RPAREN)
              sum+=izracunaj();
        pos++;
    }
    else
    {
        for (i=0; i<NATOMS; i++)
            if (ulaz[pos]==atom[i])
               sum=masa[i];
        pos++;
    }

    if (ulaz[pos]>='1' && ulaz[pos]<='9')
    {
        sum*=ulaz[pos]-'0';
        pos++;
    }

    return sum;
}

int main (void)
{
    citaj_ulaz();
    pos=0;
    rjesenje=izracunaj();
    ispisi_rjesenje();

    return 0;
}
