
// DMIH 2001 - Drugi dan natjecanja
// Srednjoskolska skupina - I. podskupina
// Zadatak IGRA
// Autor rjesenja Ante Djerek
// Nesluzbeno rjesenje

/*
    Igra - Djerek

    C-1 bod
    S-3 boda
    B-5 bodova

    Dinamicko rjesenje:
        -vremenska slozenost: O(n^2)
        -prostorma slozenost: O(n^2)

    Program pise rjesenje u OUTFILE i popunjenu tablicu u TABFILE
*/

#include <stdio.h>

#define INFILE    "igra.in"
#define OUTFILE   "igra.out"
#define TABFILE   "igra.tab"
#define MAXN      100
#define MAXK      100
#define NMOVES    3
#define ASTRING   "MIRKO"
#define BSTRING   "SLAVKO"
#define PRAZNO    '.'
#define ZID       '#'
#define NHRANE     3
#define NO         32000    /* Treba pripaziti na ovo */

char ime[NHRANE]={'C', 'S', 'B'};
int bod[NHRANE]={1, 3, 5};

int dirr[NMOVES]={0, 1, 1};
int dirs[NMOVES]={1, 0, 1};

int m, n;
char tablica[MAXN][MAXN+1];
int max[MAXN][MAXN+1];

int k;
int pocr[MAXK];
int pocs[MAXK];

void read_input (FILE *input)
{
    int i;

    fscanf(input, "%d %d", &m, &n);
    for (i=0; i<m; i++)
        fscanf(input, "%s", tablica[i]);

    fscanf(input, "%d", &k);
    for (i=0; i<k; i++)
        fscanf(input, "%d %d", &pocr[i], &pocs[i]);

}

int valid (int r, int s)
{
    if (r<0 || r>=m) return 0;
    if (s<0 || s>=n) return 0;
    return 1;
}

void solve (void)
{
    int i, j, k, l;
    int ii, jj;
    int tmp;

    for (i=m-1; i>=0; i--)
        for (j=n-1; j>=0; j--)
        {
            if (tablica[i][j]==ZID) continue;

            max[i][j]=NO;
            for (k=0; k<NMOVES; k++)
            {
                ii=i+dirr[k];
                jj=j+dirs[k];
                if (valid(ii, jj) && tablica[ii][jj]!=ZID)
                {
                    tmp=-max[ii][jj];
                    for (l=0; l<NHRANE; l++)
                        if (tablica[ii][jj]==ime[l])
                            tmp+=2*bod[l];
                    if (max[i][j]==NO || tmp>max[i][j])
                        max[i][j]=tmp;
                }
            }
            if (max[i][j]==NO)
                max[i][j]=-1;
        }
}

void write_output (FILE *output)
{
    int i;

    for (i=0; i<k; i++)
        if (max[pocr[i]-1][pocs[i]-1]>0)
            fprintf(output, "%s\n", ASTRING);
        else
            fprintf(output, "%s\n", BSTRING);
}

void dump_tablica (void)
{
    int i, j;
    FILE *tab;

    tab=fopen(TABFILE, "w");
    for (i=0; i<m; i++)
    {
        for (j=0; j<n; j++)
            if (tablica[i][j]==ZID)
                fprintf(tab, "  #");
            else
                fprintf(tab, "%3d", max[i][j]);
        fprintf(tab, "\n");
    }
    fclose(tab);
}

int main (void)
{
    FILE *input, *output;

    input=fopen(INFILE, "r");
    output=fopen(OUTFILE, "w");

    read_input(input);
    solve();
    write_output(output);
    dump_tablica();

    fclose(input);
    fclose(output);

    return 0;
}
