
// DMIH 2001 - Drugi dan natjecanja
// Srednjoskolska skupina - II. podskupina
// Zadatak MAJMUN
// Autor rjesenja Bojan Antolovic
// Nesluzbeno rjesenje

#include <stdio.h>
#include <malloc.h>
#include <assert.h>
#define INFILE "majmun.in"
#define OUTFILE "majmun.out"
#define MAXSOBA 100
#define MAXPREKIDACA 8
#define QUEUESIZE 5000
/* BROJSTANJA=2^MAXPREKIDACA*MASSOBA */
#define BROJSTANJA 25600

#define ISPIS_OBJASNJENJA 1

int n, p;
int broj_veza[MAXSOBA];
int veze[MAXSOBA][MAXSOBA];
char prekidac_mijenja_sobu[MAXPREKIDACA][MAXSOBA];
char pocetno_zakljucana[MAXSOBA];
int pocetna, zavrsna;
int nasao_cilj;

unsigned *stanja;
int stanje_prekidac[MAXPREKIDACA+1] = { 1, 2, 4, 8, 16, 32, 64, 128, 256 };
int stanja_rep, stanja_broj;
unsigned *bilo_stanje_proslo, NIJE_BILO;

int duljina_puta;
unsigned put[MAXSOBA*MAXPREKIDACA+2];

void ulaz(void)
{
	int i, j, k, t;
	FILE *f = fopen(INFILE, "rt");
    assert(f!=NULL);

	fscanf(f, "%d%d", &n, &p);
	for (i=0; i<n; i++)
	{
		fscanf(f, "%d%d", &t, &broj_veza[i]);
		pocetno_zakljucana[i] = t;
		for (j=0; j<broj_veza[i]; j++)
		{
			fscanf(f, "%d", &veze[i][j]);
			veze[i][j]--;
		}
	}
	for (i=0; i<p; i++)
	{
		for (j=0; j<n; j++)
			prekidac_mijenja_sobu[i][j] = 0;
		fscanf(f, "%d", &k);
		for (j=0; j<k; j++)
		{
			fscanf(f, "%d", &t);
			prekidac_mijenja_sobu[i][t-1] = 1;
		}
	}
	fscanf(f, "%d%d", &pocetna, &zavrsna);
	pocetna--;
	zavrsna--;
	fclose(f);

	NIJE_BILO = 0xffff;
}

void stanja_push(unsigned stanje)
{
	assert(stanja_broj<QUEUESIZE);
	stanja[(stanja_rep+stanja_broj)%QUEUESIZE] = stanje;
	stanja_broj++;
}

unsigned stanja_pop(void)
{
	unsigned stanje;
	assert(stanja_broj>0);
	stanje = stanja[stanja_rep];
	stanja_rep = (stanja_rep+1)%QUEUESIZE;
	stanja_broj--;
	return stanje;
}

void prosiri_kamo_moze(unsigned stanje)
{
	int i, j, sljedeca, zakljucana;
	for (i=0; i<broj_veza[stanje>>8]; i++)
	{
		sljedeca = veze[stanje>>8][i];
		zakljucana = pocetno_zakljucana[sljedeca];
		for (j=0; j<p; j++)
			if ((stanje&stanje_prekidac[j]) && prekidac_mijenja_sobu[j][sljedeca])
				zakljucana = !zakljucana;
		if (!zakljucana && bilo_stanje_proslo[(sljedeca<<8)+(stanje&255)]==NIJE_BILO)
		{
			bilo_stanje_proslo[(sljedeca<<8)+(stanje&255)] = stanje;
			if (sljedeca<p)
				if (bilo_stanje_proslo[((sljedeca<<8)+(stanje&255))^stanje_prekidac[sljedeca]]==NIJE_BILO)
					bilo_stanje_proslo[((sljedeca<<8)+(stanje&255))^stanje_prekidac[sljedeca]] = stanje;
			stanja_push((sljedeca<<8)+(stanje&255));
			if (sljedeca==zavrsna)
			{
				nasao_cilj = 1;
				return;
			}
		}
	}
}

void rijesi(void)
{
	unsigned s;
	stanja_broj = stanja_rep = 0;
	for (s=0; s<BROJSTANJA; s++) bilo_stanje_proslo[s] = NIJE_BILO;
	stanja_push(pocetna<<8);
	bilo_stanje_proslo[pocetna<<8] = pocetna<<8;
	nasao_cilj = 0;
	while (stanja_broj>0)
	{
		s = stanja_pop();
		prosiri_kamo_moze(s);
		if (nasao_cilj) break;
		if ((s>>8) < p)
			s^=stanje_prekidac[s>>8];
		prosiri_kamo_moze(s);
		if (nasao_cilj) break;
	}
}

void izlaz(void)
{
	FILE *f;
	unsigned s, proslo, sljedece;
	int i;
	int kraj, nije_nasao;

	nije_nasao = 1;
	for (i=0; i<stanje_prekidac[p]; i++)
		if (bilo_stanje_proslo[(zavrsna<<8)+i]!=NIJE_BILO)
		{
			s = (zavrsna<<8)+i;
			nije_nasao = 0;
			break;
		}

	f = fopen(OUTFILE, "wt");

	if (nije_nasao)
		fprintf(f, "NEMOGUCE\n");
	else
	{
		duljina_puta = 0;
		kraj = 0;
		do
		{
			put[duljina_puta++] = s;
			if ((s>>8)==pocetna)
				if ( (s&255)==0 ||
					( (s>>8)<p && (s&255)==stanje_prekidac[s>>8] ) )
					kraj = 1;
			s = bilo_stanje_proslo[s];
		} while (!kraj);


		fprintf(f, "%d\n", duljina_puta-1);

#if ISPIS_OBJASNJENJA
		fprintf(f, "\nPut:\n");
		for (i=duljina_puta-1; i>=0; i--)
		{
			fprintf(f, "%d\n", (put[i]>>8)+1);

			if ((put[i]>>8) < p)
			{
				if (i<duljina_puta-1) proslo = put[i+1]; else proslo = put[i];
				if (i>0) sljedece = put[i-1]; else sljedece = put[i];

				if ((sljedece&stanje_prekidac[put[i]>>8])
					> (proslo&stanje_prekidac[put[i]>>8]))
					fprintf(f, "prekidac %d (on)\n", (put[i]>>8)+1);
				if ((sljedece&stanje_prekidac[put[i]>>8])
					< (proslo&stanje_prekidac[put[i]>>8]))
					fprintf(f, "prekidac %d (off)\n", (put[i]>>8)+1);
			}
		}
#endif
	}

	fclose(f);
}

int main()
{
	stanja = (unsigned*)malloc(QUEUESIZE*sizeof(unsigned));
    assert(stanja!=NULL);
	bilo_stanje_proslo = (unsigned*)malloc(BROJSTANJA*sizeof(unsigned));
    assert(bilo_stanje_proslo!=NULL);

	ulaz();
	rijesi();
	izlaz();

    free(stanja);
    free(bilo_stanje_proslo);
	return 0;
}
