
{ DMIH 2001 - Drugi dan natjecanja        }
{ Srednjoskolska skupina - II. podskupina }
{ Zadatak MAJMUN                          }
{ Autor rjesenja Bojan Antolovic          }
{ Nesluzbeno rjesenje                     }

const INFILE            =  'majmun.in';
      OUTFILE           =  'majmun.out';
      MAXSOBA           =  100;
      MAXPREKIDACA      =  8;
      QUEUESIZE         =  5000;
      { BROJSTANJA=2^MAXPREKIDACA*MASSOBA }
      BROJSTANJA        =  25600;
      ISPIS_OBJASNJENJA =  True;

type ss = array[0..QUEUESIZE] of word;
type bs = array[0..BROJSTANJA] of word;

var n, p : integer;
    broj_veza : array[0..MAXSOBA] of integer;
    veze : array[0..MAXSOBA, 0..MAXSOBA] of integer;
    prekidac_mijenja_sobu : array[0..MAXPREKIDACA, 0..MAXSOBA] of boolean;
    pocetno_zakljucana : array[0..MAXSOBA] of boolean;
    pocetna, zavrsna : integer;
    nasao_cilj : boolean;
    stanja : ^ss;
    stanje_prekidac : array[0..MAXPREKIDACA] of word; { = 1, 2, 4, 8, 16, 32, 64, 128, 256 }
    stanja_rep, stanja_broj : integer;
    NIJE_BILO : word;
    bilo_stanje_proslo : ^bs;
    duljina_puta : integer;
    put : array[0..MAXSOBA*MAXPREKIDACA+2] of word;

procedure ulaz;
var i, j, k, t : integer;
    f : text;
begin
  assign (f, INFILE); reset (f);
  read (f, n, p);

  for i:=0 to n-1 do
      begin
      read (f, t, broj_veza[i]);
      if (t=1) then pocetno_zakljucana[i] := True
               else pocetno_zakljucana[i] := False;
      for j:=0 to broj_veza[i]-1 do
	  begin
          read (f, veze[i, j]);
          dec (veze[i, j]);
          end;
      end;

  for i:=0 to p-1 do
      begin
      for j:=0 to n-1 do prekidac_mijenja_sobu[i, j] := False;
      read (f, k);
      for j:=0 to k-1 do
          begin
          read (f, t);
          prekidac_mijenja_sobu[i, t-1] := True;
          end;
      end;

  read (f, pocetna, zavrsna);
  dec(pocetna); dec(zavrsna);
  close(f);

  NIJE_BILO := 65535;
end;

procedure stanja_push (stanje : word);
begin
  stanja^[(stanja_rep+stanja_broj) mod QUEUESIZE] := stanje;
  inc (stanja_broj);
end;

function stanja_pop : word;
var stanje : word;
begin
  stanje := stanja^[stanja_rep];
  stanja_rep := (stanja_rep+1) mod QUEUESIZE;
  dec (stanja_broj);

  stanja_pop := stanje;
end;

procedure prosiri_kamo_moze (stanje : word);
var i, j, sljedeca : integer;
    zakljucana : boolean;
begin
  for i:=0 to broj_veza[stanje div 256]-1 do
      begin
      sljedeca := veze[stanje div 256, i];
      zakljucana := pocetno_zakljucana[sljedeca];

      for j:=0 to p-1 do
          if (((stanje and stanje_prekidac[j])>0) and prekidac_mijenja_sobu[j, sljedeca]) then
             zakljucana := not zakljucana;

      if ((not zakljucana) and (bilo_stanje_proslo^[(sljedeca*256)+(stanje and 255)]=NIJE_BILO)) then
         begin
         bilo_stanje_proslo^[(sljedeca*256)+(stanje and 255)] := stanje;

         if (sljedeca<p) then
            if (bilo_stanje_proslo^[((sljedeca*256)+(stanje and 255)) xor stanje_prekidac[sljedeca]]=NIJE_BILO) then
               bilo_stanje_proslo^[((sljedeca*256)+(stanje and 255)) xor stanje_prekidac[sljedeca]] := stanje;

         stanja_push((sljedeca*256)+(stanje and 255));
         if (sljedeca=zavrsna) then
            begin
            nasao_cilj := True;
            exit;
            end;
         end;
      end;
end;


procedure rijesi;
var s : word;
begin
  stanja_broj := 0; stanja_rep := 0;
  for s:=0 to BROJSTANJA-1 do bilo_stanje_proslo^[s] := NIJE_BILO;
  stanja_push (pocetna*256);
  bilo_stanje_proslo^[pocetna*256] := pocetna*256;
  nasao_cilj := False;

  while (stanja_broj>0) do
    begin
    s := stanja_pop;
    prosiri_kamo_moze(s);
    if (nasao_cilj) then break;
    if ((s div 256) < p) then s:=s xor stanje_prekidac[s div 256];
    prosiri_kamo_moze(s);
    if (nasao_cilj) then break;
    end;
end;

procedure izlaz;
var f : text;
    s, proslo, sljedece : word;
    i : integer;
    kraj, nije_nasao : boolean;
begin
  nije_nasao := True;

  for i:=0 to stanje_prekidac[p]-1 do
      if (bilo_stanje_proslo^[(zavrsna*256)+i]<>NIJE_BILO) then
         begin
         s := (zavrsna*256)+i;
         nije_nasao := False;
         break;
         end;

  assign (f, OUTFILE); rewrite (f);

  if (nije_nasao) then writeln (f, 'NEMOGUCE')
                  else begin
                       duljina_puta := 0;
                       kraj := False;
                       
                       repeat;
                         put[duljina_puta] := s; inc(duljina_puta);
                         if ((s div 256)=pocetna) then
                            if (((s and 255)=0) or (((s div 8)<p) and ((s and 255)=stanje_prekidac[s div 256]))) then
                               kraj := True;
                         s := bilo_stanje_proslo^[s];
                       until (kraj);
                       
                       writeln (f, duljina_puta-1);

                       if (ISPIS_OBJASNJENJA) then
                          begin
                          writeln (f, '');
                          writeln (f, 'Put:');
                          for i:=duljina_puta-1 downto 0 do
                              begin
                              writeln (f, (put[i] div 256)+1);

                              if ((put[i] div 256) < p) then
                                 begin
                                 if (i<duljina_puta-1) then proslo := put[i+1] else proslo := put[i];
                                 if (i>0) then sljedece := put[i-1] else sljedece := put[i];

                                 if ((sljedece and stanje_prekidac[put[i] div 256])
                                      >(proslo and stanje_prekidac[put[i] div 256])) then
                                    writeln (f, 'prekidac ', (put[i] div 256)+1, ' (on)');

                                 if ((sljedece and stanje_prekidac[put[i] div 256])
                                      <(proslo and stanje_prekidac[put[i] div 256])) then
                                    writeln (f, 'prekidac ',  (put[i] div 256)+1, ' (off)');
                                 end;
		              end;
		          end;
	               end;

  close(f);
end;

begin
  new (stanja); new (bilo_stanje_proslo);

  stanje_prekidac[0]:=1;
  for n:=1 to MAXPREKIDACA do stanje_prekidac[n]:=2*stanje_prekidac[n-1];

  ulaz;
  rijesi;
  izlaz;
end.
