
/*
DMIH 2004 - Drugi dan natjecanja
Srednjoskolska skupina - I. podskupina
Zadatak MALLOC
*/

#include <cstdio>
#include <list>
#include <map>
#include <string>

using namespace std;

struct blok {
  int a, b;                                 // interval [a,b>
  blok( int aa, int bb ) { a = aa; b = bb; }
};

typedef list<blok>::iterator listiter;

list<blok> mem;
map<string, listiter> varmap;

int main( void ) {
  mem.insert( mem.end(), blok( 1, 1 ) );
  mem.insert( mem.end(), blok( 100001, 100001 ) );

  int n;
  scanf( "%d", &n );

  string var;
  char buff[100];
  for( int i = 0; i < n; ++i ) {
    scanf( "%s", buff );

    if( buff[4] == '=' ) {                  // malloc
      var = string( buff ).substr( 0, 4 );
      varmap.erase( var );

      int size;
      sscanf( buff + 12, "%d", &size );

      listiter next = mem.begin();
      listiter curr = next++;

      while( next != mem.end() ) {
        if( next->a - curr->b >= size ) break;
        ++next; ++curr;
      }

      if( next == mem.end() ) continue;
      varmap[var] = mem.insert( next, blok( curr->b, curr->b+size ) );
    }

    else if( buff[0] == 'f' ) {             // free
      var = string( buff ).substr( 5, 4 );

      if( varmap.count( var ) ) mem.erase( varmap[var] );
      varmap.erase( var );
    }

    else {                                  // print
      var = string( buff ).substr( 6, 4 );

      if( !varmap.count( var ) ) printf( "0\n" );
      else printf( "%d\n", varmap[var]->a );
    }
  }
  return 0;
}
