
{
DMIH 2004 - Drugi dan natjecanja
Srednjoskolska skupina - I. podskupina
Zadatak MALLOC
}

{
  Kako je minimalna velicina bloka kojeg treba alocirati jednaka 100, a
  velicina RAMa jedanaka 100000, maksimalan broj varijabli je 100000/100=1000.
  Varijable drzimo redom u dvostruko vezanoj listi. Slobodni dio memorije
  trazimo u jednom prolasku po toj listi, tako da gledamo ima li izmedju dvije
  susjedne varijable dovoljno mjesta za novu. Zbog toga nam za pronalazak
  slobobnog dijela memorije treba najvise 1000 operacija.
  Za svaku varijablu pamtimo njeno mjesto u vezanoj listi i zbog toga ispis
  i brisanje varijable radimo u konstantnom vremenu (brisanje elementa liste
  je jednostavna manipulacija odgovarajucih pokazivaca).
  Svako ime varijable mozemo pretvoriti u jedinstveni broj iz intervala
  [0..26^4] pomocu ASCII vrijednosti odgovarajucih slova.
}

Type
  Veza = ^Cvor;
  Cvor = Record
    Next, Prev : Veza;
    Pocetak, Duljina : longint;
  End;

Var
  Glava, Rep, t, p: Veza;
  i, N : longint;
  Varijabla, Velicina : longint;
  Naredba : string;
  Lokacija : array[0..26*26*26*26] of Veza;

Function UcitajBroj( Pozicija, Baza: longint; Dolje, Gore : char ) : longint;
Var ret : longint;
Begin
  ret := 0;
  While (Naredba[Pozicija] >= Dolje) and (Naredba[Pozicija] <= Gore) do
  Begin
    ret := ret * Baza + Ord( Naredba[Pozicija] ) - Ord( Dolje );
    Inc( Pozicija );
  End;
  UcitajBroj := ret;
End;

Begin
  New( p );
  New( t );
  p^.Next := t; p^.Prev := NIL;
  t^.Next := NIL; t^.Prev := p;
  p^.Pocetak :=      1; p^.Duljina := 0;
  t^.Pocetak := 100001; t^.Duljina := 0;
  Glava := p; Rep := t;

  Readln( N );
  For i := 1 to N do
  Begin
    Readln( Naredba );

    If Naredba[5] = '=' then
    Begin
      Varijabla := UcitajBroj( 1, 26, 'a', 'z' );
      Velicina := UcitajBroj( 13, 10, '0', '9' );
      Lokacija[Varijabla] := NIL;

      t := Glava;
      While t <> Rep do
      Begin
        If t^.Next^.Pocetak - t^.Pocetak - t^.Duljina >= Velicina then Break;
        t := t^.Next;
      End;
      If t = Rep then Continue;

      New( p );
      p^.Next := t^.Next; p^.Prev := t;
      t^.Next := p; p^.Next^.Prev := p;
      p^.Pocetak := t^.Pocetak + t^.Duljina;
      p^.Duljina := Velicina;
      Lokacija[Varijabla] := p;
    End;

    If Naredba[5] = '(' then
    Begin
      Varijabla := UcitajBroj( 6, 26, 'a', 'z' );
      t := Lokacija[Varijabla];
      If t = NIL then Continue;

      p := t^.Prev;
      p^.Next := t^.Next;
      p^.Next^.Prev := p;
      Dispose( t );
      Lokacija[Varijabla] := NIL;
    End;

    If Naredba[6] = '(' then
    Begin
      Varijabla := UcitajBroj( 7, 26, 'a', 'z' );
      t := Lokacija[Varijabla];
      If t = NIL then Writeln( 0 ) else Writeln( t^.Pocetak );
    End;
  End;
End.
