
/*
HIO 2004
Zadatak NEVENKA
*/

#include <cstdio>
#include <queue>
#include <vector>

using namespace std;

const int inf = 1000000;
int N, neve;
int n_crkava, n_bircuza;
vector<int> crkva;
vector<int> bircuz;
bool brid[1000][1000];

void input() {
  scanf( "%d%d", &N, &neve ); neve--;

  scanf( "%d", &n_crkava );
  crkva.resize( n_crkava );
  for( int i = 0; i < n_crkava; ++i ) { scanf( "%d", &crkva[i] ); crkva[i]--; }

  scanf( "%d", &n_bircuza );
  bircuz.resize( n_bircuza );
  for( int i = 0; i < n_bircuza; ++i ) { scanf( "%d", &bircuz[i] ); bircuz[i]--; }

  int m; scanf( "%d", &m );
  for( int i = 0; i < m; ++i ) {
    int v1, v2; scanf( "%d%d", &v1, &v2 ); v1--; v2--;
    brid[v1][v2] = brid[v2][v1] = 1;
  }
}

int rez[200][200];
int dist[1000];
int bio[1000];

void bfs( int source ) {
  for( int i = 0; i < N; ++i ) { dist[i] = inf; bio[i] = 0; }
  dist[source] = 0;
  bio[source] = 1;
  queue<int> Q;

  for( Q.push( source ); !Q.empty(); Q.pop() ) {
    int x = Q.front();
    for( int i = 0; i < N; ++i ) {
      if( bio[i] ) continue;
      if( !brid[x][i] ) continue;
      dist[i] = dist[x] + 1;
      bio[i] = 1;
      Q.push( i );
    }
  }
}

int solve() {
  for( int j = 0; j < n_bircuza; ++j )
    for( int k = 0; k < n_bircuza; ++k )
      rez[j][k] = -inf;
  for( int i = 0; i < n_crkava; ++i ) {
    bfs( crkva[i] );
    for( int j = 0; j < n_bircuza; ++j )
      for( int k = j+1; k < n_bircuza; ++k )
        rez[j][k] >?= min(dist[bircuz[j]],dist[bircuz[k]]) - dist[neve];
  }
  int ret = inf;
  for( int j = 0; j < n_bircuza; ++j )
    for( int k = j+1; k < n_bircuza; ++k )
      ret <?= rez[j][k];
  return ret;
}

void output( int d ) {
  for( int j = 0; j < n_bircuza; ++j )
    for( int k = j+1; k < n_bircuza; ++k )
      if( rez[j][k] == d ) {
        printf( "%d %d\n", bircuz[j]+1, bircuz[k]+1 );
        return;
      }
}

int main( void ) {
  input();
  output( solve() );
  return 0;
}
