
/*
DMIH 2004 - Prvi dan natjecanja
Srednjoskolska skupina - I. podskupina
Zadatak OTMICA
*/

#include <cstdio>
#include <queue>

using namespace std;

int R, S, N;
int v[102][102];
int l[10000];
int d[10000];

void input() {
  scanf( "%d%d", &R, &S );
  for( int i = 1; i <= R; ++i )
    for( int j = 1; j <= S; ++j )
      scanf( "%d", &v[i][j] );

  scanf( "%d", &N );
  for( int i = 0; i < N; ++i ) scanf( "%d", &l[i] );
  for( int i = 0; i < N; ++i ) scanf( "%d", &d[i] );
}

int dr[4] = { -1, 0, 1, 0 }; // dr[x], ds[x] -> pomak po retku i stupcu
int ds[4] = { 0, -1, 0, 1 }; //                 u smjeru x

struct stanje {
  int r, s, d; // koordinate lijevog nebodera i smjer prema desnom neboderu
  stanje( int rr, int ss, int dd ) { r = rr; s = ss; d = dd; }
  int id() { return r*S*4 + s*4 + d; }
};

int bio[102*102*4];
queue<stanje> q[2];
int next = 0, curr = 1;

inline void probaj( stanje t, int korak ) {
  if( bio[t.id()] == korak+1 ) return;
  if( v[ t.r         ][ t.s         ] != l[korak] ) return;
  if( v[ t.r+dr[t.d] ][ t.s+ds[t.d] ] != d[korak] ) return;

  bio[t.id()] = korak+1;
  q[next].push( t );
}

void bfs() {
  int a[4] = { 1, 2, 3, 0 };   // a[x] -> smjer lijevo smjeru x
  int b[4] = { 2, 3, 0, 1 };   // b[x] -> smjer obrnut smjeru x
  int c[4] = { 3, 0, 1, 2 };   // c[x] -> smjer desno smjeru x

  for( int i = 1; i <= R; ++i )
    for( int j = 1; j <= S; ++j )
      for( int k = 0; k < 4; ++k )
        q[curr].push( stanje( i, j, k ) );

  for( int i = 0; i < N; ++i ) {

    for( ; !q[curr].empty(); q[curr].pop() ) {
      stanje t = q[curr].front();
      int r = t.r, s = t.s, d = t.d;
      probaj( stanje( r               , s               , a[d] ), i ); // lijevo
      probaj( stanje( r+dr[a[d]]      , s+ds[a[d]]      , d    ), i ); // ravno
      probaj( stanje( r+dr[d]+dr[a[d]], s+ds[d]+ds[a[d]], c[d] ), i ); // desno
      probaj( stanje( r+dr[d]         , s+ds[d]         , b[d] ), i ); // polukruzno
    }
    curr ^= 1; next ^= 1;
  }
}

void output() {
  int dr[4] = { -1,  0, 0, -1 }; // za pretvorbu iz koordinata stanja
  int ds[4] = { -1, -1, 0,  0 }; // u koordinate raskrsca

  stanje t = q[curr].front();
  printf( "%d %d\n", t.r+dr[t.d], t.s+ds[t.d] );
}

int main( void ) {
  input();
  bfs();
  output();
  return 0;
}
