
/*
  DMIH 2005 - Prvi dan natjecanja
  Srednjoskolska skupina - II. podskupina
  Zadatak JMBG

  Rjesavanje problema mozemo podijeliti na 3 dijela:
  - izracunavanje na koliko se nacina moze dobiti svaki od ostataka
  pri dijeljenju s 19 iz lijevog (datumskog) dijela JMBG-a
  - isto za drugi dio JMBG-a, koji se sastoji od proizvoljnih znamenki
  - kombiniranje ta dva podrjesenja u konacno

  Za prvi dio problema trebamo generirati sve datume koji odgovaraju uzorku 
  (vidi funkcije gen_datume i lijevi_dio).

  Drugi dio racunamo dinamicki (vidi funkciju desni_dio).

  Preostaje jos spojiti rjesenja, tj. vidjeti na koliko nacina kombinacijom
  ostataka iz prvog i drugog dijela mozemo dobiti zadanu kontrolnu znamenku, ako
  je zadana, ili sve moguce kontrolne znamenke ako nije (funkcija spoji).
*/

#include <cstdio>
#include <cstring>
#include <vector>

using namespace std;

char jmbg[20];
vector<int> dani, mjeseci, godine;
int mod1[19], mod2[19];
long long koja_koliko[10];
long long ukupno = 0;

void gen_datume()
{
   for ( int d=1; d<=31; ++d )
      if ( ( jmbg[0] == 'X' || jmbg[0] == '0'+d/10 ) &&
           ( jmbg[1] == 'X' || jmbg[1] == '0'+d%10 ) )
         dani.push_back( d );

   for ( int mj=1; mj<=12; ++mj )
      if ( ( jmbg[2] == 'X' || jmbg[2] == '0'+mj/10 ) &&
           ( jmbg[3] == 'X' || jmbg[3] == '0'+mj%10 ) )
         mjeseci.push_back( mj );

   for ( int a=0; a<10; ++a ) if ( jmbg[4] == 'X' || jmbg[4] == '0'+a )
      for ( int b=0; b<10; ++b ) if ( jmbg[5] == 'X' || jmbg[5] == '0'+b )
         for ( int c=0; c<10; ++c ) if ( jmbg[6] == 'X' || jmbg[6] == '0'+c )
            for ( int d=0; d<10; ++d ) if ( jmbg[7] == 'X' || jmbg[7] == '0'+d )
               if ( a+b+c+d != 0 )
                  godine.push_back( a*1000+b*100+c*10+d );
}

int koliko_dana( int mj, int god )
{
   static const int koliko[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
   if ( mj == 2 && ( god%400 == 0 || god%4 == 0 && god%100 != 0 ) ) return 29;
   return koliko[mj-1];
}

void lijevi_dio()
{
   dani.push_back( 999 ); // sentinel
   for ( int g=0; g<(int)godine.size(); ++g )
      for ( int m=0; m<(int)mjeseci.size(); ++m ) {
         int to = koliko_dana( mjeseci[m], godine[g] );
         for ( int d=0; dani[d]<=to; ++d )
            ++mod1[ ( 6*(godine[g]/1000) + 5*(godine[g]/100%10) + 4*(godine[g]/10%10) + 3*(godine[g]%10) +
                      8*(mjeseci[m]/10) + 7*(mjeseci[m]%10) + 10*(dani[d]/10) + 9*(dani[d]%10) ) % 19 ];
      }
}

void desni_dio()
{
   int k = 2;
   static int c[11][19];

   c[0][0] = 1;
   for ( int i=0; i<10; ++i ) {
      for ( int z=0; z<10; ++z ) if ( jmbg[8+i] == 'X' || jmbg[8+i] == '0'+z )
         for ( int m=0; m<19; ++m )
            c[i+1][(m+k*z)%19] += c[i][m];
      if ( --k < 2 ) k = 10;
   }

   for ( int m=0; m<19; ++m )
      mod2[m] = c[10][m];
}

void spoji()
{
   for ( int l=0; l<19; ++l )
      for ( int d=0; d<19; ++d ) {
         koja_koliko[ (l+d)%19<10? (l+d)%19 : 19-(l+d)%19 ] += (long long)mod1[l] * mod2[d];
         ukupno += (long long)mod1[l] * mod2[d];
      }
}

int main()
{
   scanf( "%s", jmbg );
   gen_datume();
   lijevi_dio();
   desni_dio();
   spoji();

   if ( jmbg[18] == 'X' ) printf( "%lld\n", ukupno );
   else printf( "%lld\n", koja_koliko[ jmbg[18]-'0' ] );

   return 0;
}
