
/*
  DMIH 2005 - Prvi dan natjecanja
  Srednjoskolska skupina - I. podskupina
  Zadatak AUTOPUT

  Zadatak rjesavamo metodom dinamickog programiranja i to tako da nam stanje
  a(K, X) oznacava najmanje moguce vrijeme da dodjemo do pozicije X ako smo do
  sada izgradili tocno K tunela ili vijadukta.

  Neka desno(X) oznacava prvu poziciju desno od pozicije X iste visine kao i ona.

  Tada iz stanja a(K, X) mozemo izracunati moguce vrijednosti za stanja:
  a(K, X+1)        - ako prodjemo polje bez tunela ili vijadukta
  a(K+1, desno(X)) - ako sagradimo tunel ili vijadukt od pozicije X do desno(X)

  Primjetimo da nam je, ako racunamo po retcima, dovoljno pamtiti samo dva retka
  (K-ti i (K+1)-ti redak) tablice a, buduci da nemamo dovoljno memorije za
  pamtiti cijelu tablicu.
*/

#include <cstdio>
#include <vector>

using namespace std;

const int inf = 1000000000;

int main( void ) {
   int A, B, C;
   int N, M, H;
   scanf( "%d%d%d%d%d ", &A, &B, &C, &N, &M );

   vector<int> visina( N+1, 0 );
   int minh=0, maxh=0;
   for( int i = 1; i <= N; ++i ) {
      char c;
      scanf( "%c", &c );
      if( c == 'D' ) visina[i] = visina[i-1] - 1;
      if( c == 'R' ) visina[i] = visina[i-1];
      if( c == 'G' ) visina[i] = visina[i-1] + 1;
      minh <?= visina[i];
      maxh >?= visina[i];
   }

   for( int i = 0; i <= N; ++i ) visina[i] -= minh;
   H = maxh-minh;

   vector< int > zadnja( H+1, -1 );
   vector< int > desno( N+1, -1 );

   for( int i = 0; i <= N; ++i ) {
      if( i > 0 && visina[i] != visina[i-1] && zadnja[visina[i]] != -1 )
         desno[zadnja[visina[i]]] = i;
      zadnja[visina[i]] = i;
   }

   vector< int > a[2];
   a[0] = a[1] = vector<int> (N+1, inf);
   a[0][0] = 0;

   int rjesenje = inf;
   for( int K = 0; K <= M; ++K ) {
      int k = K%2;
      int kplus1 = (K+1)%2;

      for( int x = 0; x <= N; ++x ) a[kplus1][x] = inf;
      for( int x = 0; x < N; ++x ) {
         if( visina[x+1] == visina[x]+1 ) a[k][x+1] <?= a[k][x] + B;
         if( visina[x+1] == visina[x]   ) a[k][x+1] <?= a[k][x] + A;
         if( visina[x+1] == visina[x]-1 ) a[k][x+1] <?= a[k][x] + B;
         if( desno[x] != -1 ) a[kplus1][desno[x]] <?= a[k][x] + C*(desno[x]-x);
      }
      rjesenje <?= a[k][N];
   }

   printf( "%d\n", rjesenje );

   return 0;
}
