
/*
  DMIH 2005 - Prvi dan natjecanja
  Srednjoskolska skupina - I. podskupina
  Zadatak TOMO

  Pamcenje cijelog broja koji je trenutno prikazan na kalkulatoru nije prakticno
  pa moramo primijetiti da je dovoljno pamtiti zadnjih K znamenaka, gdje je K 
  broj znamenaka u zadanom broju C. Zadnjih K znamenaka nekog broja mozemo 
  dobiti kao cjelobrojni ostatak pri dijeljenju tog broja s 10^(K+1). Prvi dio 
  rjesenja je racunanje te potencije broja 10 (varijabla pot10 u ovoj 
  implementaciji).

  Zatim simuliramo operacije na kalkulatoru (cijelo vrijeme modulo pot10) i 
  cekamo da se na ekranu pojavi broj C.

  Primijetimo da je dovoljno izvrsiti pot10 mnozenja, jer, ako se broj C ne 
  pojavi u tih pot10 iteracija, nece se nikad (po Dirichletovom principu): neki 
  drugi broj se morao pojaviti dva puta, sto znaci da smo operacijama usli u 
  ciklus.
*/

#include <stdio.h>
#include <string.h>

#define MAXC 1000000

int main( void )
{
  int a, b, c, pot10, rj;
  scanf( "%d%d%d", &a, &b, &c );

  pot10 = 1; while ( pot10 <= c ) pot10 *= 10;
  a %= pot10;

  for ( rj = 1; rj <= pot10; ++rj ) {
    a = a * b % pot10;

    if ( a == c ) {
      printf( "%d\n", rj );
      return 0;
    }
  }
  puts( "NIKAD" );

  return 0;
}
