
/*
  DMIH 2005 - Prvi dan natjecanja
  Srednjoskolska skupina - I. podskupina
  Zadatak ZMIJA

  Zadatak rjesavamo simulacijom pravila danih u tekstu zadatka. Matrica bio nam 
  za svako polje (r, s) govori kad je zadnji put zmijina glava bila na tom 
  polju. Dogadjaj (sretanje) obradjujemo na nacin da simuliramo sve pomake od 
  proslog dogadjaja do njega i za svaki pomak provjerimo sljedece:

  1. Ako je glava izasla iz polja, prekidamo igru
  2. Ako je glava na polju gdje je jabuka, pojedemo jabuku i produzimo zmiju
  3. Ako je zmijino tijelo jos uvijek na tom polju, prekidamo igru
  4. Postavljamo novo vrijeme zadnjeg posjeta
  5. Skrecemo zmiju lijevo ili desno

  Nakon zadnjeg dogadjaja, pustimo zmiju da ide dok joj glava ne izadje iz 
  polja. Kad izadje, prekidamo igru.
*/

#include <stdio.h>
#include <stdlib.h>

#define MAX_N 100
#define MAX_TIME 10000

int dr[] = { 0, 1, 0, -1 };
int ds[] = { 1, 0, -1, 0 };

int jabuka[MAX_N][MAX_N];
int bio[MAX_N][MAX_N];

void zavrsi( int rezultat )
{
  printf( "%d\n", rezultat - 1 );
  exit( 0 );
}

int main( void )
{
  int N, K, L, i, r, s;
  int vrijeme, smjer, duljina;

  scanf( "%d%d", &N, &K );

  // Glava nije bila na nijednom polju
  for( r = 0; r < N; ++r )
    for( s = 0; s < N; ++s )
      bio[r][s] = -1;

  // Postavimo jabuke
  for( i = 0; i < K; ++i )
  {
    scanf( "%d%d", &r, &s );
    jabuka[--r][--s] = 1;
  }

  // U trenutku nula zmija je duga 1 kvadratic i krece se desno
  vrijeme = 1;
  duljina = 1;
  smjer = 0;

  scanf( "%d", &L );

  bio[r = 0][s = 0] = 0;
  for( i = 0; i <= L; ++i )
  {
    // Ovaj dogadjaj obradjujemo nakon zadnjeg ucitanog
    int novo_vrijeme = MAX_TIME + 1;
    char skretanje = 'L';

    // Ucitaj dogadjaj
    if( i < L ) scanf( "%d %c", &novo_vrijeme, &skretanje );

    // Simuliraj kretanje do trenutka dogadjaja
    while( vrijeme <= novo_vrijeme )
    {
      vrijeme++;

      r += dr[smjer];
      s += ds[smjer];

      // Je li izasla iz polja
      if( r < 0 || s < 0 || r >= N || s >= N )
        zavrsi( vrijeme );

      // Je li pojela jabuku
      if( jabuka[r][s] )
      {
        jabuka[r][s] = 0;
        duljina++;
      }

      // Je li ugrizla sama sebe
      if( vrijeme - bio[r][s] <= duljina )
        zavrsi( vrijeme );

      // Novi zadnji posjet
      bio[r][s] = vrijeme;
    }

    // Skretanje
    if( skretanje == 'L' )
      smjer = (smjer + 3) % 4;
    else // if( skretanje == 'D' )
      smjer = (smjer + 1) % 4;
  }

  return 0;
}
