
/*
  DMIH 2005 - Drugi dan natjecanja
  Srednjoskolska skupina - II. podskupina
  Zadatak LABUDOVI

  Simuliramo otapanje leda, dan po dan, i izmedju svaka dva otapanja
  provjeravamo moze li jedan labud doci do drugoga.

  Za otapanje leda i pretrazivanje svih polja do kojih moze jedan labud doci
  koristimo strukturu red (queue) i to 2 queuea za otapanje i jos 2 queuea za
  pretrazivanje kako bi osigurali da svako polje najvise jedanput otopimo i
  pretrazimo.

  Dakle, ukupna vremenska slozenost je O(R*S).
*/

#include <cstdio>
#include <queue>

using namespace std;

int R, S;
struct coords {
   short r, s;
   coords() {}
   coords( int rr, int ss ) { r = rr; s = ss; }
   int ok() { return r >= 0 && r < R && s >= 0 && s < S; }
   friend coords operator + ( const coords &a, const coords &b ) {
      return coords( a.r + b.r, a.s + b.s );
   }
};

coords labud1, labud2;
char bio[1500][1500];
char otopio[1500][1500];
char jezero[1500][1501];

queue<coords> labud_danas, labud_sutra;
queue<coords> otopi_danas, otopi_sutra;

int main( void ) {
   scanf( "%d%d", &R, &S );

   int broj = 0;
   for( int r = 0; r < R; ++r ) {
      scanf( "%s", jezero[r] );
      for( int s = 0; s < S; ++s ) {
         if( jezero[r][s] == 'L' ) {
            if( ++broj == 1 ) labud1 = coords( r, s );
            else              labud2 = coords( r, s );
            jezero[r][s] = '.';
         }
         if( jezero[r][s] == '.' ) { otopio[r][s] = 1; otopi_sutra.push( coords( r, s ) ); }
      }
   }

   const coords delta[4] = { coords( -1, 0 ), coords( 0, 1 ), coords( 1, 0 ), coords( 0, -1 ) };

   labud_sutra.push( labud1 );
   bio[labud1.r][labud1.s] = 1;

   int dan;
   for( dan = 0; !bio[labud2.r][labud2.s]; ++dan ) {

      // premjesti sutra u danas... dosao je novi dan
      for( ; !labud_sutra.empty(); labud_sutra.pop() ) labud_danas.push( labud_sutra.front() );
      for( ; !otopi_sutra.empty(); otopi_sutra.pop() ) otopi_danas.push( otopi_sutra.front() );

      // otopi danas i nadji sto ce se sutra otopit
      for( ; !otopi_danas.empty(); otopi_danas.pop() ) {
         coords a = otopi_danas.front();
         jezero[a.r][a.s] = '.';
         for( int d = 0; d < 4; ++d ) {
            coords b = a+delta[d];
            if( !b.ok() || otopio[b.r][b.s] ) continue;

            otopio[b.r][b.s] = 1;
            otopi_sutra.push( b );
         }
      }

      // istrazi nova polja u koja moze labud1 doci
      for( ; !labud_danas.empty(); labud_danas.pop() ) {
         coords a = labud_danas.front();
         for( int d = 0; d < 4; ++d ) {
            coords b = a+delta[d];
            if( !b.ok() || bio[b.r][b.s] ) continue;

            bio[b.r][b.s] = 1;
            if( jezero[b.r][b.s] == '.' ) labud_danas.push( b );
            if( jezero[b.r][b.s] == 'X' ) labud_sutra.push( b );
         }
      }
   }

   printf( "%d\n", dan-1 );

   return 0;
}
