
(*
  DMIH 2005 - Drugi dan natjecanja
  Srednjoskolska skupina - I. podskupina
  Zadatak LOPTA

  Krecemo od ociglednog rjesenja, odnosno pri svakom okretanju table okrecemo
  cijelu tablicu u memoriji i nakon toga loptu spustamo dok ne dodje do poda.
  Ovo rjesenje ima slozenost O(K*N*N) jer za svako okretanje moramo zakrenuti
  cijelu tablicu.

  Primjetimo da cijela tabla moze biti u ukupno 4 razlicite rotacije. Dakle,
  mozemo prije okretanja naci sve 4 rotacije, pa pri svakom okretanju samo
  pamtimo u kojoj od 4 tablice se nalazimo.
  Osim toga pamtimo i poziciju lopte, te je nakon rotacije spustimo na pod u
  odgovarajucoj tablici.
  Ovo rjesenje ima slozenost O(N*N+K*N); N*N za izracunati 4 rotacije i K*N za
  spustiti loptu na pod nakon svake rotacije.

  Kako je K*N i dalje poveci broj, da bi dobili sve bodove moramo, takodjer
  prije svih okretanja, za svaku poziciju u svakoj od 4 rotacije izracunati
  mjesto na koje ce lopta pasti s te pozicije.
  To nas dovodi do konacnog rjesenja slozenosti O(N*N+K).
*)

program lopta;

const MAXN = 1000;

type Ttabla = array[1..MAXN, 1..MAXN] of char;

var n, k, loptar, loptas : longint;
    tabla : array[1..4] of Ttabla;
    padni : array[1..4, 1..MAXN, 1..MAXN] of integer;
    c : char;

    r, s, i, j : longint;
    rotacija, novir, novis : longint;

procedure rotiraj(var a, b : Ttabla);
var r, s : longint;
begin
   for r:=1 to n do
      for s:=1 to n do
         b[s, n-r+1] := a[r, s];
end;

begin
   readln(n, k);

   for r:=1 to n do
   begin
      for s:=1 to n do
      begin
         read(c);
         if c='L' then
         begin
            c:='.';
            loptar:=r;
            loptas:=s;
         end;
         tabla[1][r, s]:=c;
      end;
      readln;
   end;

   for i:=2 to 4 do rotiraj(tabla[i-1], tabla[i]);

   for i:=1 to 4 do
   begin
      for r:=n downto 1 do
         for s:=1 to n do
         begin
            if r<n then if tabla[i][r+1, s]='.' then
            begin
               padni[i, r, s]:=padni[i, r+1, s];
               continue;
            end;
            padni[i, r, s] := r;
         end;
   end;

   rotacija := 1;

   for i:=1 to k do
   begin
      readln(c);
      if c='D' then
      begin
         novir:=loptas;
         novis:=n-loptar+1;
         rotacija:=rotacija+1;
      end else
      begin
         novir:=n-loptas+1;
         novis:=loptar;
         rotacija:=rotacija-1;
      end;
      loptar := novir;
      loptas := novis;

      if rotacija < 1 then rotacija := rotacija + 4;
      if rotacija > 4 then rotacija := rotacija - 4;

      loptar := padni[rotacija, loptar, loptas];
   end;

   tabla[rotacija, loptar, loptas] := 'L';
   for i:=1 to n do
   begin
      for j:=1 to n do write(tabla[rotacija][i, j]);
      writeln;
   end;
end.
