
/*
  HIO 2005
  Zadatak DEVA

  Prvi dio zadatka odnosi se na saznavanje koji od zadanih gradova su spojeni
  putevima kracim od L cesta.
  Za pretrazivanje do L cesta u sirinu iz zadanih gradova treba nam u najgorem
  slucaju vise od 8*4^10 poziva funkcije Susjedi.

  Zato trebamo koristiti "meet in the middle" metodu, odnosno, prosirimo se iz
  svakog od zadanih gradova do L/2 cesta u sirinu.
  Ako se iz grada A moze doci u grad C koristeci manje od L/2 cesta, te se iz
  grada B moze doci u grad C koristeci manje od L/2 cesta, onda se sigurno moze
  doci iz grada A u grad B koristeci manje od L cesta.

  Ovakavim nacinom pretrage korjenovali smo ukupan broj pitanja koji sad iznosi
  najvise 8*(1+5+5*4+5*4*4+5*4*4*4) = 3408 pitanja

  Drugi dio zadatka odnosi se na trazenje hamiltonovog ciklusa u grafu s najvise
  8 cvorova. Zbog malog broja cvorova, to mozemo naci isprobavanjem svih 8!
  permutacija gradova dok ne nadjemo onu koja je moguca.
*/

#include "devalib.h"
#include <queue>

using namespace std;

#define MAXN 1000000

int n, m, k;
int gradovi[8];

char bitan[MAXN+1];
char dist[8][MAXN+1];
int  how[8][MAXN+1];

int broj[MAXN+1];
int susjedi[MAXN+1][5];

void bfs( int grad ) {
   dist[grad][gradovi[grad]] = 0;
   queue<int> Q;
   for( Q.push( gradovi[grad] ); !Q.empty(); Q.pop() ) {
      int a = Q.front();
      if( dist[grad][a] >= (m+1)>>1 ) break;
      if( broj[a] == -1 ) Susjedi( a, &broj[a], susjedi[a] );

      for( int i = 0; i < broj[a]; ++i ) {
         int b = susjedi[a][i];
         if( dist[grad][b] <= dist[grad][a] + 1 ) continue;
         dist[grad][b] = dist[grad][a] + 1;
         how[grad][b] = a;
         if( !bitan[b] ) Q.push( b );
      }
   }
}

int g[8][8];

void napravi_graf() {
   for( int i = 0; i < k; ++i )
      for( int j = i+1; j < k; ++j )
         for( int a = 1; a <= n; ++a ) {
            if( dist[i][a] + dist[j][a] > m ) continue;
            if( a != gradovi[i] && a != gradovi[j] && bitan[a] ) continue;
            g[i][j] = g[j][i] = a;
            break;
         }
}

int bio[8];
int niz[9];

int rec( int a, int i ) {
   niz[i] = a;
   if( i == k ) return a == 0;

   for( int b = 0; b < k; ++b ) {
      if( !g[a][b] ) continue;
      if( bio[b] ) continue;

      bio[b] = 1;
      if( rec( b, i+1 ) ) return 1;
      bio[b] = 0;
   }
   return 0;
}

int rj_size;
int rj[100];

void reconstruct_pre( int i, int a ) {
   if( a == -1 ) return;
   if( rj[rj_size-1] != a ) rj[rj_size++] = a;
   reconstruct_pre( i, how[i][a] );
}
void reconstruct_post( int i, int a ) {
   if( a == -1 ) return;
   reconstruct_post( i, how[i][a] );
   if( rj[rj_size-1] != a ) rj[rj_size++] = a;
}

int main( void ) {
   Init( &n, &m );
   Gradovi( &k, gradovi );

   memset( dist, 0x3F, sizeof dist );
   memset( broj, -1, sizeof broj );
   memset( how, -1, sizeof how );

   for( int i = 0; i < k; ++i ) bitan[gradovi[i]] = 1;
   for( int i = 0; i < k; ++i ) bfs( i );

   napravi_graf();

   rec( 0, 0 );

   rj[rj_size++] = gradovi[0];
   for( int i = 0; i < k; ++i ) {
      reconstruct_post( niz[i], g[niz[i]][niz[i+1]] );
      reconstruct_pre( niz[i+1], g[niz[i]][niz[i+1]] );
   }

   Rjesenje( rj_size, rj );

   return 0;
}
