
(*
  HIO 2005
  Zadatak DEVA
*)

program deva;
uses devalib;

const MAXN = 1000000;
      MAXQ = 2000;

var n, m, k, i, j : longint;
    gr      : array[0..7]          of longint;

    bitan   : array[0..MAXN]       of boolean;
    dist    : array[0..7, 0..MAXN] of shortint;
    how     : array[0..7, 0..MAXN] of longint;
    broj    : array[0..MAXN]       of longint;
    susj    : array[0..MAXN, 0..4] of longint;

    bio : array[0..7] of boolean;
    niz : array[0..8] of longint;

    rj_size : longint;
    rj : array[0..99] of longint;

    g  : array[0..7, 0..7] of longint;

    q : array[0..MAXQ] of longint;
    qp, qk : longint;
    procedure push(a : longint);
    begin
      q[qp]:=a;
      if qp<MAXQ then qp:=qp+1 else qp:=0;
    end;
    function pop : longint;
    begin
      pop:=q[qk];
      if qk<MAXQ then qk:=qk+1 else qk:=0;
    end;

procedure bfs(grad : longint);
var a, b, i : longint;
begin
   dist[grad, gr[grad]] := 0;
   qp:=0;
   qk:=0;
   push(gr[grad]);
   while qp<>qk do
   begin
      a := pop;
      if dist[grad, a] >= ((m+1)shr 1) then break;
      if broj[a]=-1 then Susjedi(a, broj[a], susj[a]);
      for i:=0 to broj[a]-1 do
      begin
         b := susj[a, i];
         if dist[grad, b] <= dist[grad, a] + 1 then continue;
         dist[grad, b] := dist[grad, a] + 1;
         how[grad, b] := a;
         if not bitan[b] then push(b);
      end;
   end;
end;

procedure napravi_graf;
var i, j, a : longint;
begin
   for i := 0 to k-1  do
      for j:=i+1 to k-1 do
         for a:=1 to n do
         begin
            if dist[i, a] + dist[j, a] > m then continue;
            if (a <> gr[i])and(a <> gr[j])and bitan[a] then continue;
            g[j, i] := a;
            g[i, j] := a;
            break;
         end;
end;

function rec(a, i : longint) : boolean;
var b : longint;
begin
   niz[i] := a;
   if i = k then
   begin
      rec:=a=0;
      exit;
   end;
   for b:=0 to k-1 do
   begin
      if g[a, b]=0 then continue;
      if bio[b] then continue;
      bio[b] := true;
      if rec(b, i+1) then
      begin
         rec:=true;
         exit;
      end;
      bio[b] := false;
   end;
   rec:=false;
end;

procedure reconstruct_pre(i, a : longint);
begin
   if a = -1 then exit;
   if rj[rj_size-1] <> a then
   begin
      rj[rj_size] := a;
      rj_size:=rj_size+1;
   end;
   reconstruct_pre(i, how[i, a]);
end;

procedure reconstruct_post(i, a : longint);
begin
   if a = -1 then exit;
   reconstruct_post( i, how[i, a] );
   if rj[rj_size-1] <> a then
   begin
       rj[rj_size] := a;
       rj_size:=rj_size+1;
   end;
end;

begin
   Init( n, m );
   Gradovi( k, gr );

   for i:=0 to 7 do for j:=0 to MAXN do dist[i, j]:=63;
   for i:=0 to 7 do for j:=0 to MAXN do how[i, j]:=-1;
   for i:=0 to MAXN do broj[i]:=-1;

   for i:=0 to k-1 do bitan[gr[i]]:=true;
   for i:=0 to k-1 do bfs(i);

   napravi_graf;

   rec( 0, 0 );

   rj[rj_size] := gr[0];
   rj_size:=rj_size+1;

   for i:=0 to k-1 do
   begin
      reconstruct_post( niz[i], g[niz[i], niz[i+1]] );
      reconstruct_pre( niz[i+1], g[niz[i], niz[i+1]] );
   end;

   Rjesenje( rj_size, rj );
end.
