
/*
  HIO 2005
  Zadatak VID

  Zadatak rjesavamo tako da u svakom koraku izracunamo (a) broj novih parova
  koji se dobro vide i (b) broj parova koji se vise ne vide zbog dodane tocke.

  Prvi broj nalazimo na sljedeci nacin: tocke najprije translatiramo tako da se
  dodana tocka nalazi u ishodistu, zatim za svaki kvadrant posebno pronadjemo
  broj tocaka koje se dobro vide sa ishodistem.
  Ovo se moze jednostavno naci ako su tocke prikladno sortirane; na primjer, za
  tocke u prvom kvadrantu (gore desno) vrijedi da ako su sortirane uzlazno po y
  koordinati, onda se tocka dobro vidi sa ishodistem ako i samo ako je ne
  zaklanja do sada najvisa tocka koja se dobro vidi sa ishodistem. Za ostale
  kvadrante je pravilo slicno.

  Da bi pronasli drugi broj, potrebno je primjetiti da se parovi tocaka koji se
  vise ne vide zbog dodane tocke moraju nalaziti u nasuptrotnim kvadrantima.
  Broj nalazimo tako da za svaku tocku koja se dobro vidi sa ishodistem (njih
  smo nasli u prvom koraku), izracunamo broj tocaka iz nasuptrotnog kvadranta sa
  kojima se dobro vidi bez ishodista.
  Ako drzimo tocke sortirane ovaj dio se takodjer moze efikasno implementirati.

  Slozenost: O(n^2)
*/

#include <iostream>

using namespace std;

const int INF=(1<<30);

struct tocka
{
  int x;
  int y;
  tocka (int xx=0, int yy=0)
        {
    x=xx;
    y=yy;
  }
};

int kvadrant (const tocka &t)
{
  if (t.x>0)
  {
    if (t.y>=0) return 0;
    return 3;
  }
  if (t.y>0) return 1;
  return 2;
}

int ispred (const tocka &t, const tocka &a)
{
  if (t.x<min(0, a.x) || t.x>max(0, a.x)) return 0;
  if (t.y<min(0, a.y) || t.y>max(0, a.y)) return 0;
  return 1;
}

int n;
tocka *tox;
tocka *toy;

int *kx;
int *ky;

int nk[4];
tocka *kv[4];

int broj;

void dodaj (int k, int x, int y)
{
  // translatiraj
  for (int i=0; i<k; i++)
  {
    tox[i].x-=x;
    tox[i].y-=y;
    toy[i].x-=x;
    toy[i].y-=y;
    kx[i]=kvadrant(tox[i]);
    ky[i]=kvadrant(toy[i]);
  }

  // kvadranti su prazni
  for (int i=0; i<4; i++)
    nk[i]=0;

  // prvi kvadrant
  for (int i=0; i<k; i++)
  {
    if (ky[i]!=0) continue ;
    if (nk[0]==0 || !ispred(kv[0][nk[0]-1], toy[i]))
      kv[0][nk[0]++]=toy[i];
  }

  // drugi kvadrant
  for (int i=k-1; i>=0; i--)
  {
    if (kx[i]!=1) continue ;
    if (nk[1]==0 || !ispred(kv[1][nk[1]-1], tox[i]))
      kv[1][nk[1]++]=tox[i];
  }

  // treci kvadrant
  for (int i=k-1; i>=0; i--)
  {
    if (ky[i]!=2) continue ;
    if (nk[2]==0 || !ispred(kv[2][nk[2]-1], toy[i]))
      kv[2][nk[2]++]=toy[i];
  }

  // cetvrti kvadrant
  for (int i=0; i<k; i++)
  {
    if (kx[i]!=3) continue ;
    if (nk[3]==0 || !ispred(kv[3][nk[3]-1], tox[i]))
      kv[3][nk[3]++]=tox[i];
  }

  // dodaj nove parove
  for (int i=0; i<4; i++)
    broj+=nk[i];

  // mici parove koji se vise ne vide
  for (int c=0; c<2; c++)
  {
    int i1=nk[1]-1;
    int i3=nk[3]-1;
    int i2d=0;
    int i2g=0;
    for (int i=0; i<nk[0]; i++)
    {
      while (i1>=0 && kv[1][i1].y<=kv[0][i].y) i1--;
      while (i3>=0 && kv[3][i3].x>kv[0][i].x) i3--;
      int gx=i1==nk[1]-1?-INF:kv[1][i1+1].x;
      int gy=i3<0?-INF:kv[3][i3].y;
      while (i2g<nk[2] && kv[2][i2g].y>gy) i2g++;
      while (i2d<i2g && kv[2][i2d].x<=gx) i2d++;
      broj-=i2g-i2d;
      if (i2d==nk[2]) break ;
    }

    // rotiraj za 90 stupnjeva
    tocka *temp=kv[3];
    kv[3]=kv[2];
    kv[2]=kv[1];
    kv[1]=kv[0];
    kv[0]=temp;
    int tempi=nk[3];
    nk[3]=nk[2];
    nk[2]=nk[1];
    nk[1]=nk[0];
    nk[0]=tempi;
    for (int i=0; i<4; i++)
      for (int j=0; j<nk[i]; j++)
        kv[i][j]=tocka(-kv[i][j].y, kv[i][j].x);
  }

  // ubaci novu tocku, nema tocaka sa istom x ili y koordinatom
  int i=k;
  while (i>0)
  {
    if (tox[i-1].x>0)
      tox[i]=tox[i-1];
    else
      break ;
    i--;
  }
  tox[i]=tocka(0, 0);

  i=k;
  while (i>0)
  {
    if (toy[i-1].y>0)
      toy[i]=toy[i-1];
    else
      break ;
    i--;
  }
  toy[i]=tocka(0, 0);
}

int main (void)
{
  cin >> n;

  tox=new tocka[n];
  toy=new tocka[n];
  kx=new int[n];
  ky=new int[n];
  for (int i=0; i<4; i++)
    kv[i]=new tocka[n];

  broj=0;
  int xx=0;
  int yy=0;
  for (int i=0; i<n; i++)
  {
    int x, y;
    cin >> x >> y;
    dodaj(i, x-xx, y-yy);
    xx=x;
    yy=y;
    cout << broj << endl;
  }

  delete tox;
  delete toy;
  delete kx;
  delete ky;
  for (int i=0; i<4; i++)
    delete kv[i];

  return 0;
}
