
/*
  HIO 2005
  Zadatak XL

  Kako bi nam bilo lakse, na pocetku generiramo niz koji sadrzi sve rimske
  brojeve manje od 900 (brojeve vece od 899 ne mozemo sloziti jer se u zadatku
  ne pojavljuje rimska znamenka M), zajedno s tockama izmedu njih. Sad nam je
  cilj doci sto dalje u tom nizu, micuci se po ploci, a rjesenje broj tocaka
  koje smo presli. Niz sadrzi 6300 znakova.

  Zadatak mozemo pretvoriti u problem pretrazivanja stanja u kojem nam je stanje
  definirano s dva podatka: indeksom slova na kojem smo trenutno (u velikom
  nizu) te koordinatama na ploci. Stanje je ilegalno ako su ta dva podatka
  kontradiktorna. Svako stanje je povezano sa cetiri druga, koja imaju indeks
  slova veci za jedan, a na jednom su od cetiri susjedna polja.

  Mozemo primijetiti da je ovaj graf aciklicki (DAG - directed acyclic graph), a
  trazi se najdulji put iz pocetnog vrha. Taj najdulji put mozemo naci BFS-om
  ili dinamicki. Pri sirenju po grafu pazimo da ne posjetimo ilegalno stanje.

  Ova implementacija nalazi rjesenje dinamicki, iako ju je jednostavno
  promijeniti da radi BFS. Implementacija na BFS-u je brza jer ne posjecuje
  stanja do kojih nije moguce doci iz pocetnog, ali je vrijeme izvrsavanja oba
  algoritma u najgorem slucaju theta(ukupno_stanja).

  Ukupan broj stanja je duljina_niza * N^2.
*/

#include <algorithm>
#include <cstdio>
#include <string>

using namespace std;

#define MAXN 100

string roman( int x )
{
   static const char *stotice[]  = { "", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC" };
   static const char *desetke[]  = { "", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC" };
   static const char *jedinice[] = { "", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX" };
   return string( stotice[ x/100 ] ) + string( desetke[ x/10%10 ] ) + string( jedinice[ x%10 ] );
}

int main()
{
   int n;
   static char tabla[MAXN][MAXN+1];

   scanf( "%d", &n );
   for ( int i=0; i<n; ++i )
      scanf( "%s", tabla[i] );

   string s = ".";
   for ( int i=1; i<900; ++i )
      s += roman( i ) + string( 1, '.' );
   s.push_back( '*' );

   static int c[2][MAXN][MAXN];
   int now = 0, prev = 1;

   for ( int p=s.length()-1; p>=0; --p ) {
      for ( int i=0; i<n; ++i )
         for ( int j=0; j<n; ++j ) {
            c[now][i][j] = 0;
            if ( tabla[i][j] == s[p] ) {
               c[now][i][j] = 1;
               for ( int dir=0; dir<4; ++dir ) {
                  static const int di[] = { -1, 0, 1, 0 };
                  static const int dj[] = { 0, 1, 0, -1 };
                  int ni = i+di[dir], nj = j+dj[dir];
                  if ( ni < 0 || ni >= n || nj < 0 || nj >= n ) continue;

                  if ( c[prev][ni][nj] > 0 )
                     c[now][i][j] >?= c[prev][ni][nj] + 1;
               }
            }
         }

      swap( now, prev );
   }

   printf( "%d\n", count( s.begin(), s.begin() + c[prev][n/2][n/2], '.' ) - 1 );

   return 0;
}
