
(*
  HIO 2005
  Zadatak XL

  Kako bi nam bilo lakse, na pocetku generiramo niz koji sadrzi sve rimske
  brojeve manje od 900 (brojeve vece od 899 ne mozemo sloziti jer se u zadatku
  ne pojavljuje rimska znamenka M), zajedno s tockama izmedu njih. Sad nam je
  cilj doci sto dalje u tom nizu, micuci se po ploci, a rjesenje broj tocaka
  koje smo presli. Niz sadrzi 6300 znakova.

  Zadatak mozemo pretvoriti u problem pretrazivanja stanja u kojem nam je stanje
  definirano s dva podatka: indeksom slova na kojem smo trenutno (u velikom
  nizu) te koordinatama na ploci. Stanje je ilegalno ako su ta dva podatka
  kontradiktorna. Svako stanje je povezano sa cetiri druga, koja imaju indeks
  slova veci za jedan, a na jednom su od cetiri susjedna polja.

  Mozemo primijetiti da je ovaj graf aciklicki (DAG - directed acyclic graph), a
  trazi se najdulji put iz pocetnog vrha. Taj najdulji put mozemo naci BFS-om
  ili dinamicki. Pri sirenju po grafu pazimo da ne posjetimo ilegalno stanje.
*)

program xl;

const MAXN   = 99;
      MAXLEN = 6300;

      ZNAMENKE : array[1..3, 0..9] of string = (
        ('', 'I', 'II', 'III', 'IV', 'V', 'VI', 'VII', 'VIII', 'IX'),
        ('', 'X', 'XX', 'XXX', 'XL', 'L', 'LX', 'LXX', 'LXXX', 'XC'),
        ('', 'C', 'CC', 'CCC', 'CD', 'D', 'DC', 'DCC', 'DCCC', 'DM'));


type Tpolje = record
                 x, y : longint;
              end;

var niz   : array[1..MAXLEN] of char;
    mapa  : array[0..MAXN+1, 0..MAXN+1] of char;
    bilo  : array[0..MAXN+1, 0..MAXN+1] of longint;
    polja : array[0..1, 1..MAXN*MAXN] of Tpolje;
    pp    : array[0..1] of longint;
    n, i, j, nizpos, rjesenje, novi, stari, x, y : longint;

procedure dodaj(st, z : longint; var nizpos : longint);
var i : longint;
begin
  for i:=1 to length(ZNAMENKE[st][z]) do
  begin
     nizpos:=nizpos+1;
     niz[nizpos]:=ZNAMENKE[st][z][i];
  end;
end;
function polje(x, y : longint) : Tpolje;
begin
  polje.x:=x;
  polje.y:=y;
end;

procedure stavi(x, y : longint);
begin
  if (mapa[x, y]=niz[i])and(bilo[x, y]<i) then
  begin
     pp[novi]:=pp[novi]+1;
     polja[novi, pp[novi]]:=polje(x, y);
     bilo[x, y]:=i;
  end;
end;

begin
  readln(n);
  for i:=0 to n+1 do
  begin
     mapa[i, 0]:='-';
     mapa[i, n+1]:='-';
     mapa[0, i]:='-';
     mapa[n+1, i]:='-';
  end;
  for i:=1 to n do
  begin
     for j:=1 to n do read(mapa[i, j]);
     readln;
  end;
  nizpos:=0;
  for i:=1 to 899 do
  begin
     dodaj(3, i div 100, nizpos);
     dodaj(2, i div 10 mod 10, nizpos);
     dodaj(1, i mod 10, nizpos);
     nizpos:=nizpos+1;
     niz[nizpos]:='.';
  end;
  pp[1]:=1;
  polja[1, 1]:=polje(n div 2 + 1, n div 2 + 1);
  rjesenje:=0;
  for i:=1 to n do for j:=1 to n do bilo[i, j]:=0;
  for i:=1 to nizpos do
  begin
     stari := i mod 2;
     novi  := (i+1) mod 2;
     pp[novi]:=0;
     for j:=1 to pp[stari] do
     begin
        x:=polja[stari, j].x;
        y:=polja[stari, j].y;
        stavi(x+1, y);
        stavi(x-1, y);
        stavi(x, y-1);
        stavi(x, y+1);
     end;
     if pp[novi]=0 then break;
     if niz[i]='.' then rjesenje:=rjesenje+1;
  end;
  writeln(rjesenje);
end.
