
/*
  DMIH 2005 - Drugi dan natjecanja
  Srednjoskolska skupina - I. podskupina
  Zadatak LOPTA

  Krecemo od ociglednog rjesenja, odnosno pri svakom okretanju table okrecemo
  cijelu tablicu u memoriji i nakon toga loptu spustamo dok ne dodje do poda.
  Ovo rjesenje ima slozenost O(K*N*N) jer za svako okretanje moramo zakrenuti
  cijelu tablicu.

  Primjetimo da cijela tabla moze biti u ukupno 4 razlicite rotacije. Dakle,
  mozemo prije okretanja naci sve 4 rotacije, pa pri svakom okretanju samo
  pamtimo u kojoj od 4 tablice se nalazimo.
  Osim toga pamtimo i poziciju lopte, te je nakon rotacije spustimo na pod u
  odgovarajucoj tablici.
  Ovo rjesenje ima slozenost O(N*N+K*N); N*N za izracunati 4 rotacije i K*N za
  spustiti loptu na pod nakon svake rotacije.

  Kako je K*N i dalje poveci broj, da bi dobili sve bodove moramo, takodjer
  prije svih okretanja, za svaku poziciju u svakoj od 4 rotacije izracunati
  mjesto na koje ce lopta pasti s te pozicije.
  To nas dovodi do konacnog rjesenja slozenosti O(N*N+K).
*/

#include <algorithm>
#include <cstdio>

#define MAXN 1001

using namespace std;

int n, k;
char tabla[4][MAXN][MAXN];
short padni[4][MAXN][MAXN];
int loptar, loptas;

void rotiraj( char a[][MAXN], char b[][MAXN] ) {
   for( int r = 0; r < n; ++r )
      for( int s = 0; s < n; ++s )
         b[s][n-r-1] = a[r][s];
}

int main( void ) {
   scanf( "%d%d", &n, &k );

   for( int r = 0; r < n; ++r ) {
      scanf( "%s", tabla[0][r] );
      for( int s = 0; s < n; ++s )
         if( tabla[0][r][s] == 'L' ) {
            tabla[0][r][s] = '.';
            loptar = r;
            loptas = s;
         }
   }

   for( int i = 1; i < 4; ++i ) rotiraj( tabla[i-1], tabla[i] );

   for( int i = 0; i < 4; ++i ) {
      for( int r = n-1; r >= 0; --r )
         for( int s = 0; s < n; ++s ) {
            if( r < n-1 && tabla[i][r+1][s] == '.' ) padni[i][r][s] = padni[i][r+1][s];
            else padni[i][r][s] = r;
         }
   }

   char c;
   int rotacija = 0, novir, novis;
   for( int i = 1; i <= k; ++i ) {
      scanf( " %c", &c );
      if( c == 'D' ) { novir = loptas, novis = n-loptar-1; rotacija++; }
      else           { novir = n-loptas-1, novis = loptar; rotacija--; }
      loptar = novir; loptas = novis;

      if( rotacija < 0 ) rotacija += 4;
      if( rotacija > 3 ) rotacija -= 4;

      loptar = padni[rotacija][loptar][loptas];
   }

   tabla[rotacija][loptar][loptas] = 'L';
   for( int i = 0; i < n; ++i ) printf( "%s\n", tabla[rotacija][i] );

   return 0;
}
