
/*
  DMIH 2005 - Drugi dan natjecanja
  Srednjoskolska skupina - I. podskupina
  Zadatak NOGOMET

  Definiramo rekurzivnu funkciju za sortiranje jedne podlige, po pravilima u
  zadatku (vidi funkciju moj_sort sa komentarima).
  Rjesenje dobijemo pozivanjem te funkcije za cijelu ligu.
*/

#include <stdio.h>
#include <stdlib.h>

#define MAXN 100

typedef struct {
   int bodova, pob, zab, prim, index;
} stat;

int n;
int bodova_protiv[MAXN+1][MAXN+1];
stat timovi[MAXN+1];

int cmp_bodovi( const stat *a, const stat *b )
{
   if ( a->bodova > b->bodova ) return -1;
   if ( a->bodova < b->bodova ) return 1;
   return 0;
}

int cmp_ostalo( const stat *a, const stat *b )
{
   if ( a->zab - a->prim > b->zab - b->prim ) return -1;
   if ( a->zab - a->prim < b->zab - b->prim ) return 1;
   if ( a->zab > b->zab ) return -1;
   if ( a->zab < b->zab ) return 1;
   if ( a->pob > b->pob ) return -1;
   if ( a->pob < b->pob ) return 1;
   if ( a->index < b->index ) return -1;
   if ( a->index > b->index ) return 1;
   return 0;
}

void moj_sort( int a, int b )
/* sortira momcadi na indeksima a do b (b iskljucivo) */
{
   /* samo jedna momcad? */
   if ( a > b ) return;

   /* izracunavamo broj bodova svake ekipe u ovoj podligi */
   for ( int i=a; i<b; ++i )
      timovi[i].bodova = 0;
   for ( int i=a; i<b; ++i )
      for ( int j=a; j<b; ++j )
         timovi[i].bodova += bodova_protiv[ timovi[i].index ][ timovi[j].index ];

   /* sortiramo silazno po broju bodova, koristi se funkcija cmp_bodovi */
   qsort( timovi+a, b-a, sizeof( *timovi ), (int (*)(const void *, const void *))cmp_bodovi );

   /* ukoliko ima vise ekipa s istim brojem bodova, rekurzivno pozovemo moj_sort na svakoj od grupa */
   int od = a;
   for ( int i=a+1; i<b; ++i ) {
      if ( timovi[od].bodova > timovi[i].bodova ) {
         moj_sort( od, i );
         od = i;
      }
   }

   if ( od == a ) {
      /* ako sve ekipe imaju isti broj bodova, sortiramo po ostalim statistikama (cmp_ostalo) */
      qsort( timovi+a, b-a, sizeof( *timovi ), (int (*)(const void *, const void *))cmp_ostalo );
   }
   else {
      /* u suprotnom, sortiramo i zadnji blok ekipa */
      moj_sort( od, b );
   }
}

int main(void)
{
   int u;
   scanf( "%d%d", &n, &u );
   for ( int i=1; i<=n; ++i )
      timovi[i].index = i;

   for ( int i=0; i<u; ++i ) {
      int a, b, doma, gost;
      scanf( "%d%d%d:%d", &a, &b, &doma, &gost );

      timovi[a].zab += doma; timovi[a].prim += gost;
      timovi[b].zab += gost; timovi[b].prim += doma;
      if ( doma > gost ) {
         timovi[a].pob++; bodova_protiv[a][b] += 3;
      }
      else if ( doma < gost ) {
         timovi[b].pob++; bodova_protiv[b][a] += 3;
      }
      else {
         bodova_protiv[a][b] += 1;
         bodova_protiv[b][a] += 1;
      }
   }

   moj_sort( 1, n+1 );
   for ( int i=1; i<=n; ++i )
      printf( "%d%c", timovi[i].index, i==n?'\n':' ' );

   return 0;
}
