
/*
  DMIH 2005 - Drugi dan natjecanja
  Srednjoskolska skupina - I. podskupina
  Zadatak RIBARI

  Ovaj zadatak rjesavamo tako da radimo binarno pretrazivanje po broju djece jer
  je moguce na efikasan nacin provjeriti mogu li ovi gradovi prehraniti K djece
  po gradu.
*/

#include <stdio.h>

#define MAX_N 100000

int n;
int position[MAX_N];
int food[MAX_N];

int ok( int K )
{
  long long carry = 0;
  int i;

  // Za svaki grad s lijeva na desno
  for( i = 0; i < n - 1; ++i )
  {
    // Ako je carry negativan, onda je abs(carry) kolicina hrane koju
    // grad i mora uvesti iz grada desno od sebe.
    // Ako je carry pozitivan, onda je abs(carry) kolicina hrane koju
    // grad i moze izvesi u grad desno od sebe.
    long long x = food[i] + carry;

    if( x <  K )
    {
      // Ovu kolicinu hrane moramo uvesti
      carry = x - K - (position[i + 1] - position[i]);
    }
    else // if( x >= K )
    {
      // Ovu kolicinu hrane mozemo izvesti
      carry = x - K - (position[i + 1] - position[i]);
      // Ako gubici veci od poslane kolicine, onda ne saljemo nista
      if(carry < 0) carry = 0;
    }
  }

  return (food[n - 1] + carry) >= K;
}

int main( void )
{
  int i;
  int low = 1, high = 1;

  scanf( "%d", &n );

  for( i = 0; i < n; ++i )
  {
    scanf( "%d%d", &position[i], &food[i] );
    if( food[i] > high ) high = food[i];
  }

  // Binarno pretrazivanje
  while( low < high )
  {
    int mid = (low + high + 1) / 2;
    if( ok( mid ) )
      low = mid;
    else
      high = mid - 1;
  }

  printf( "%d\n", low );

  return 0;
}
