
(*
  DMIH 2005 - Drugi dan natjecanja
  Srednjoskolska skupina - I. podskupina
  Zadatak RIBARI

  Ovaj zadatak rjesavamo tako da radimo binarno pretrazivanje po broju djece jer
  postoji efikasan nacin na koji je moguce provjeriti mogu li ovi gradovi
  prehraniti K djece po gradu.
*)

program ribari;

const MAXN = 100000;

type llong = int64;

var position, food : array[0..MAXN-1] of longint;
    n, i, low, high, mid : longint;

function ok(k : longint) : boolean;
var carry, x : llong;
    i : longint;
begin
   carry:=0;
  // Za svaki grad s lijeva na desno
  for i:=0 to n-2 do
  begin
    // Ako je carry negativan, onda je abs(carry) kolicina hrane koju
    // grad i mora uvesti iz grada desno od sebe.
    // Ako je carry pozitivan, onda je abs(carry) kolicina hrane koju
    // grad i moze izvesi u grad desno od sebe.
    x := food[i] + carry;

    if x<K then
    begin
      // Ovu kolicinu hrane moramo uvesti
      carry := x - K - (position[i+1] - position[i]);
    end
    else if x>= K then
    begin
      // Ovu kolicinu hrane mozemo izvesti
      carry := x - K - (position[i + 1] - position[i]);
      // Ako gubici veci od poslane kolicine, onda ne saljemo nista
      if carry<0 then carry := 0;
    end;
  end;
   ok := (food[n-1]+carry)>=K;
end;

begin
   low := 1;
   high := 1;

  readln(n);

   for i:=0 to n-1 do
   begin
      readln(position[i], food[i]);
    if food[i]>high then high := food[i];
  end;

  // Binarno pretrazivanje
  while low < high do
  begin
    mid := (low + high + 1) div 2;
    if ok(mid) then
      low := mid
    else
      high := mid - 1;
  end;

  writeln(low);
end.
