
(*
  DMIH 2005 - Prvi dan natjecanja
  Srednjoskolska skupina - II. podskupina
  Zadatak JMBG

  Rjesavanje problema mozemo podijeliti na 3 dijela:
  - izracunavanje na koliko se nacina moze dobiti svaki od ostataka
    pri dijeljenju s 19 iz lijevog (datumskog) dijela JMBG-a
  - isto za drugi dio JMBG-a, koji se sastoji od proizvoljnih znamenki
  - kombiniranje ta dva podrjesenja u konacno

  Za prvi dio problema trebamo generirati sve datume koji odgovaraju uzorku 
  (vidi funkcije gen_datume i lijevi_dio).

  Drugi dio racunamo dinamicki (vidi funkciju desni_dio).

  Preostaje jos spojiti rjesenja, tj. vidjeti na koliko nacina kombinacijom
  ostataka iz prvog i drugog dijela mozemo dobiti zadanu kontrolnu znamenku, ako
  je zadana, ili sve moguce kontrolne znamenke ako nije (funkcija spoji).
*)

program zadatak_jmbg;

type llong = int64;

(* inicijalizirane varijable, a ne konstante: *)
const mjeseci_broj : longint = 0;
      godine_broj : longint = 0;
      dani_broj : longint = 0;

      broj_dana_u_mjesecu : array[1..12] of longint =
            (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);

var
   jmbg : string[19];

   dani : array[0..31] of longint;
   mjeseci : array[0..11] of longint;
   godine : array[0..9999] of longint;

   mod1, mod2 : array[0..18] of llong;

   koja_koliko : array[0..9] of llong;

   ukupno : llong;

procedure gen_datume;
var a, b, c, d : longint;
begin
   for a:=1 to 31 do
      if ((jmbg[1]='X')or(jmbg[1]=chr(a div 10+ord('0'))))and
         ((jmbg[2]='X')or(jmbg[2]=chr(a mod 10+ord('0')))) then
         begin
            dani[dani_broj]:=a;
            dani_broj:=dani_broj+1;
         end;

   for a:=1 to 12 do
      if ((jmbg[3]='X')or(jmbg[3]=chr(a div 10+ord('0'))))and
         ((jmbg[4]='X')or(jmbg[4]=chr(a mod 10+ord('0')))) then
         begin
            mjeseci[mjeseci_broj]:=a;
            mjeseci_broj:=mjeseci_broj+1;
         end;

   for a:=0 to 9 do if (jmbg[5]='X')or(jmbg[5]=chr(a+ord('0'))) then
      for b:=0 to 9 do if (jmbg[6]='X')or(jmbg[6]=chr(b+ord('0'))) then
         for c:=0 to 9 do if (jmbg[7]='X')or(jmbg[7]=chr(c+ord('0'))) then
             for d:=0 to 9 do if (jmbg[8]='X')or(jmbg[8]=chr(d+ord('0'))) then
               if a+b+c+d<>0 then
               begin
                  godine[godine_broj]:=a*1000+b*100+c*10+d;
                  godine_broj:=godine_broj+1;
               end;
end;

function koliko_dana(mj, god : longint) : longint;
begin
   if (mj=2)and((god mod 400=0)or((god mod 4=0)and(god mod 100<>0))) then
      koliko_dana:=29 else koliko_dana:=broj_dana_u_mjesecu[mj];
end;

procedure lijevi_dio;
var g, m, t, d, temp : longint;
begin
   dani[dani_broj]:=999;

   for g:=0 to godine_broj-1 do
      for m:=0 to mjeseci_broj-1 do
      begin
         t := koliko_dana( mjeseci[m], godine[g] );
         d:=0;
         while dani[d]<=t do
         begin
            temp := ( 6*(godine[g] div 1000) + 5*(godine[g] div 100 mod 10) + 4*(godine[g]div 10 mod 10) + 3*(godine[g] mod 10) +
                      8*(mjeseci[m]div 10) + 7*(mjeseci[m] mod 10) + 10*(dani[d] div 10) + 9*(dani[d]mod 10) ) mod 19;

            mod1[temp] := mod1[temp] + 1;

            d:=d+1;
         end;
      end;
end;

procedure desni_dio;
var k, i, z, m : longint;
    c : array[0..10, 0..18] of longint;
begin
   for k:=0 to 10 do for i:=0 to 18 do c[k, i]:=0;
   k := 2;
   c[0, 0] := 1;
   for i:=0 to 9 do
   begin
      for z:=0 to 9 do if (jmbg[9+i]='X')or(jmbg[9+i]=chr(ord('0')+z)) then
         for m:=0 to 18 do c[i+1, (m+k*z) mod 19]:=c[i+1, (m+k*z) mod 19]+c[i, m];
      k:=k-1;
      if k<2 then k:=10;
   end;

   for m:=0 to 18 do mod2[m]:=c[10, m];
end;

procedure spoji;
var l, d, temp : longint;
begin
   ukupno:=0;
   for l:=0 to 18 do
      for d:=0 to 18 do
      begin
         if (l+d) mod 19<10 then temp:=(l+d) mod 19 else temp:=19-(l+d)mod 19;
         koja_koliko[temp]:=koja_koliko[temp]+ mod1[l]*mod2[d];
         ukupno:=ukupno+mod1[l]*mod2[d];
      end;
end;

begin
   readln(jmbg);
   gen_datume;
   lijevi_dio;
   desni_dio;
   spoji;

   if jmbg[19] = 'X' then writeln(ukupno)
   else writeln(koja_koliko[ord(jmbg[19])-ord('0')]);
end.
