
/*
  DMIH 2005 - Prvi dan natjecanja
  Srednjoskolska skupina - II. podskupina
  Zadatak KVADRAT

  Kljucna stvar u rjesenju zadatka je saznati kolika je magicna suma (suma 
  svakog retka, svakog stupca i glavne i sporedne dijagonale). Ako imamo redak, 
  stupac ili dijagonalu koja je vec popunjena, samo zbrojimo elemente i imamo 
  magicnu sumu. Jedini slucaj kad nemamo niti jedan popunjeni redak, stupac ili
  dijagonalu, jest kad su nepoznata polja (nule) na glavnoj ili sporednoj
  dijagonali. Tada je magicna suma jednaka polovici sume svih poznatih 
  elemenata.

  Kad imamo poznatu magicnu sumu, obradjujemo nepoznata polja jedno po jedno
  pazeci na to da mozemo popuniti samo polje koje se nalazi u retku ili stupcu
  (ili dijagonali) u kojem su svi ostali elementi poznati.
*/

#include <stdio.h>

int main( void )
{
  int a[3][3], suma = 0;
  int i, j, ponavljaj;

  for( i = 0; i < 3; ++i )
    for( j = 0; j < 3; ++j )
      scanf("%d", &a[i][j]);

  // Postoji li popunjeni redak
  for( i = 0; i < 3; ++i )
    if( (a[i][0] == 0) + (a[i][1] == 0) + (a[i][2] == 0) == 0 )
      suma = a[i][0] + a[i][1] + a[i][2];

  // Postoji li popunjeni stupac
  for( j = 0; j < 3; ++j )
    if( (a[0][j] == 0) + (a[1][j] == 0) + (a[2][j] == 0) == 0 )
      suma = a[0][j] + a[1][j] + a[2][j];

  // Je li glavna dijagonala popunjena
  if( (a[0][0] == 0) + (a[1][1] == 0) + (a[2][2] == 0) == 0 )
    suma = a[0][0] + a[1][1] + a[2][2];

  // Je li sporedna dijagonala popunjena
  if( (a[0][2] == 0) + (a[1][1] == 0) + (a[2][0] == 0) == 0)
    suma = a[0][2] + a[1][1] + a[2][0];

  // Ako nema popunjenog reda, stupca ili dijagonale, onda su nule
  // na dijagonali, pa je suma jednaka polovini sume svih elemenata
  if( suma == 0 )
  {
    for( i = 0; i < 3; ++i )
      for( j = 0; j < 3; ++j )
        suma += a[i][j];
    suma /= 2;
  }

  // Mici nule koje su same u retku ili stupcu dok ih ima
  for( ponavljaj = 0; ponavljaj < 3; ++ponavljaj )
  {
    for( i = 0; i < 3; ++i )
      for( j = 0; j < 3; ++j )
      {
        // Zamijenu nulu ako je sama u retku
        if( (a[i][j] == 0) && (a[i][0] == 0) + (a[i][1] == 0) + (a[i][2] == 0) == 1 )
          a[i][j] = suma - a[i][0] - a[i][1] - a[i][2];

        // Zamijenu nulu ako je sama u stupcu
        if( (a[i][j] == 0) && (a[0][j] == 0) + (a[1][j] == 0) + (a[2][j] == 0) == 1 )
          a[i][j] = suma - a[0][j] - a[1][j] - a[2][j];
      }
  }

  // Ispisi rjesenje.
  for( i = 0; i < 3; ++i )
  {
    for( j = 0; j < 3; ++j )
    {
      if( j ) printf( " " );
      printf( "%d", a[i][j] );
    }
    printf( "\n" );
  }

  return 0;
}
