
(*
  DMIH 2005 - Prvi dan natjecanja
  Srednjoskolska skupina - II. podskupina
  Zadatak KVADRAT

  Kljucna stvar u rjesenju zadatka je saznati kolika je magicna suma (suma 
  svakog retka, svakog stupca i glavne i sporedne dijagonale). Ako imamo redak, 
  stupac ili dijagonalu koja je vec popunjena, samo zbrojimo elemente i imamo 
  magicnu sumu. Jedini slucaj kad nemamo niti jedan popunjeni redak, stupac ili
  dijagonalu, jest kad su nepoznata polja (nule) na glavnoj ili sporednoj
  dijagonali. Tada je magicna suma jednaka polovici sume svih poznatih 
  elemenata.

  Kad imamo poznatu magicnu sumu, obradjujemo nepoznata polja jedno po jedno
  pazeci na to da mozemo popuniti samo polje koje se nalazi u retku ili stupcu
  (ili dijagonali) u kojem su svi ostali elementi poznati.
*)

program kvadrat;

var a : array[1..3, 1..3] of longint;
    suma, i, j, ponavljaj :  longint;

begin

   // Ucitaj podatke
   for i:=1 to 3 do readln(a[i, 1], a[i, 2], a[i, 3]);

   suma:=0;

  // Postoji li popunjeni redak
  for i:=1 to 3 do
     if (a[i, 1]<>0)and(a[i, 2]<>0)and(a[i, 3]<>0) then suma:=a[i, 1]+a[i, 2]+a[i, 3];

  // Postoji li popunjeni stupac
  for i:=1 to 3 do
     if (a[1, i]<>0)and(a[2, i]<>0)and(a[3, i]<>0) then suma:=a[1, i]+a[2, i]+a[3, i];

  // Je li glavna dijagonala popunjena
  if (a[1, 1]<>0)and(a[2, 2]<>0)and(a[3, 3]<>0) then suma:=a[1, 1]+a[2, 2]+a[3, 3];

  // Je li sporedna dijagonala popunjena
  if (a[1, 3]<>0)and(a[2, 2]<>0)and(a[3, 1]<>0) then suma:=a[1, 3]+a[2, 2]+a[3, 1];

  // Ako nema popunjenog reda, stupca ili dijagonale, onda su nule
  // na dijagonali, pa je suma jednaka polovini sume svih elemenata
  if suma=0 then
  begin
     for i:=1 to 3 do
        for j:=1 to 3 do suma:=suma+a[i, j];
     suma:=suma div 2;
  end;

  // Mici nule koje su same u retku ili stupcu dok ih ima
  for ponavljaj:=1 to 3 do
     for i:=1 to 3 do
        for j:=1 to 3 do if a[i, j]=0 then
        begin
        // Zamijenu nulu ako je sama u retku
        if (a[i, j]=0)and(a[i, j mod 3 + 1]<>0)and(a[i, (j+1) mod 3 + 1]<>0) then
          a[i][j] := suma - a[i][1] - a[i][2] - a[i][3];

        // Zamijenu nulu ako je sama u stupcu
        if (a[i, j]=0)and(a[i mod 3 + 1, j]<>0)and(a[(i+1) mod 3 + 1, j]<>0) then
          a[i][j] := suma - a[1][j] - a[2][j] - a[3][j];
      end;

   // Ispisi rezultat
   for i:=1 to 3 do writeln(a[i, 1], ' ', a[i, 2], ' ', a[i, 3]);
end.
