
/*
  DMIH 2005 - Prvi dan natjecanja
  Srednjoskolska skupina - II. podskupina
  Zadatak SVEMIR

  Zadatak rjesavamo tako da vrsimo binarno pretrazivanje pojednicano po svakoj
  koordinati. Tijekom pretrazivanja po nekoj koordinati vazno je da su ostale
  dvije fiksirane, tj. da u svim pozivima koristimo iste vrijednosti. Binarno
  pretrazivanje vrsimo tako da u svakom koraku skacemo s lijevog ruba intervala 
  na desni i, u ovisnosti o odgovoru, nastavljamo pretrazivanje po lijevoj ili 
  desnoj polovici intervala.

  Kako je maksimalni broj tocaka po pojedinoj koordinati ogranicen na
  N = 1.000.000.000, maksimalni broj pitanja je 3*2*log2(N) = 180.
*/

#include "libsvemir.h"

int main(void)
{
  int n, dim, t;
  int left[3], right[3];

  n = DajN();

  left[0] = left[1] = left[2] = 1;
  right[0] = right[1] = right[2] = 1;

  for(dim = 0; dim < 3; dim++)
  {
     left[dim]=1;
     right[dim]=n;
    // Binarno pretrazivanje
    while(1)
    {
      Pomak(left[0], left[1], left[2]);
      t = Pomak(right[0], right[1], right[2]);

      if(t == 0)
      {
        left[dim] = right[dim] = (left[dim] + right[dim]) / 2;
        break;
      }

      if(t == -1)
      {
        left[dim] = (left[dim] + right[dim] + 1) / 2;
      }
      else // if(t == 1)
      {
        right[dim] = (left[dim] + right[dim]) / 2;
      }
    }
  }

  Pomak(left[0], left[1], left[2]);

  return 0;
}
