
(*
  DMIH 2005 - Prvi dan natjecanja
  Srednjoskolska skupina - II. podskupina
  Zadatak SVEMIR

  Zadatak rjesavamo tako da vrsimo binarno pretrazivanje pojedinacno po svakoj
  koordinati. Tijekom pretrazivanja po nekoj koordinati vazno je da su ostale
  dvije fiksirane, tj. da u svim pozivima koristimo iste vrijednosti. Binarno
  pretrazivanje vrsimo tako da u svakom koraku skacemo s lijevog ruba intervala 
  na desni i, u ovisnosti o odgovoru, nastavljamo pretrazivanje po lijevoj ili 
  desnoj polovici intervala.

  Kako je maksimalni broj tocaka po pojedinoj koordinati ogranicen na
  N = 1.000.000.000, maksimalni broj pitanja je 3*2*log2(N) = 180.
*)

program svemir;
uses libsvemir;

var n, dim, t   : longint;
    left, right : array[1..3] of longint;

begin
  n := DajN;

   left[1]:=1; right[1]:=1;
   left[2]:=1; right[2]:=1;
   left[3]:=1; right[3]:=1;

   for dim:=1 to 3 do
   begin
      left[dim]:=1;
      right[dim]:=n;
    // Binarno pretrazivanje
    while true do
    begin
      Pomak(left[1], left[2], left[3]);
      t := Pomak(right[1], right[2], right[3]);

      if t=0 then
      begin
         right[dim] := (left[dim] + right[dim]) div 2;
        left[dim] := right[dim];
        break;
      end;

      if t=-1 then
        left[dim] := (left[dim] + right[dim] + 1) div 2;
      if t=1 then
        right[dim] := (left[dim] + right[dim]) div 2;
    end;
  end;

  Pomak(left[1], left[2], left[3]);
end.
