
(*
  HIO 2005
  Zadatak VID

  Zadatak rjesavamo tako da u svakom koraku izracunamo (a) broj novih parova
  koji se dobro vide i (b) broj parova koji se vise ne vide zbog dodane tocke.

  Prvi broj nalazimo na sljedeci nacin: tocke najprije translatiramo tako da se
  dodana tocka nalazi u ishodistu, zatim za svaki kvadrant posebno pronadjemo
  broj tocaka koje se dobro vide sa ishodistem.
  Ovo se moze jednostavno naci ako su tocke prikladno sortirane; na primjer, za
  tocke u prvom kvadrantu (gore desno) vrijedi da ako su sortirane uzlazno po y
  koordinati, onda se tocka dobro vidi sa ishodistem ako i samo ako je ne
  zaklanja do sada najvisa tocka koja se dobro vidi sa ishodistem. Za ostale
  kvadrante je pravilo slicno.

  Da bi pronasli drugi broj, potrebno je primjetiti da se parovi tocaka koji se
  vise ne vide zbog dodane tocke moraju nalaziti u nasuptrotnim kvadrantima.
  Broj nalazimo tako da za svaku tocku koja se dobro vidi sa ishodistem (njih
  smo nasli u prvom koraku), izracunamo broj tocaka iz nasuptrotnog kvadranta sa
  kojima se dobro vidi bez ishodista.
  Ako drzimo tocke sortirane ovaj dio se takodjer moze efikasno implementirati.

  Slozenost: O(n^2)
*)

program vid;

const INF  : longint = 1 shl 30;
      MAXN = 5000;

type tocka = record
               x, y : longint;
             end;
     tocke = array[0..MAXN-1] of tocka;

var
   n, i, x, y, xx, yy, broj : longint;
  kx, ky : array[0..MAXN-1] of longint;
   nk : array[0..3] of longint;
   tox, toy : tocke;
   kv : array[0..3] of tocke;

function kvadrant(var t : tocka) : longint;
begin
  if t.x>0 then
  begin
    if t.y>=0 then kvadrant:=0 else kvadrant:=3;
  end else
  begin
     if t.y>0 then kvadrant:=1 else kvadrant:=2;
  end;
end;

function ispred(var t, a : tocka) : boolean;
 function min(a, b : longint) : longint;
 begin
    if a<=b then min:=a else min:=b;
 end;
 function max(a, b : longint) : longint;
 begin
    if a>=b then max:=a else max:=b;
 end;
begin
   if (t.x<min(0, a.x))or(t.x>max(0, a.x)) then ispred:=false else
  if (t.y<min(0, a.y))or(t.y>max(0, a.y)) then ispred:=false else ispred:=true;
end;

procedure dodaj(k, x, y : longint);
var i, j, c, tempi : longint;
    i1, i3, i2d, i2g, gx, gy : longint;
    temp : tocke;
begin
  // translatiraj
  for i:=0 to k-1 do
  begin
    tox[i].x:=tox[i].x-x;
    tox[i].y:=tox[i].y-y;
    toy[i].x:=toy[i].x-x;
    toy[i].y:=toy[i].y-y;
    kx[i]:=kvadrant(tox[i]);
    ky[i]:=kvadrant(toy[i]);
  end;

  // kvadranti su prazni
  for i:=0 to 3 do nk[i]:=0;

  // prvi kvadrant
  for i:=0 to k-1 do
  begin
    if ky[i]<>0 then continue;
    if nk[0]>0 then if ispred(kv[0][nk[0]-1], toy[i]) then continue;
      kv[0][nk[0]]:=toy[i];
     nk[0]:=nk[0]+1;
  end;

  // drugi kvadrant
  for i:=k-1 downto 0 do
  begin
     if kx[i]<>1 then continue;
     if nk[1]>0 then if ispred(kv[1][nk[1]-1], tox[i]) then continue;
      kv[1][nk[1]]:=tox[i];
      nk[1]:=nk[1]+1;
  end;

  // treci kvadrant
  for i:=k-1 downto 0 do
  begin
     if ky[i]<>2 then continue;
     if nk[2]>0 then if ispred(kv[2][nk[2]-1], toy[i]) then continue;
     kv[2][nk[2]]:=toy[i];
    nk[2]:=nk[2]+1;
  end;

  // cetvrti kvadrant
  for i:=0 to k-1 do
  begin
    if kx[i]<>3 then continue ;
    if nk[3]>0 then if ispred(kv[3][nk[3]-1], tox[i]) then continue;
    kv[3][nk[3]]:=tox[i];
    nk[3]:=nk[3]+1;
  end;

  // dodaj nove parove
  for i:=0 to 3 do broj:=broj+nk[i];

  // mici parove koji se vise ne vide
  for c:=0 to 1 do
  begin
    i1:=nk[1]-1;
    i3:=nk[3]-1;
    i2d:=0;
    i2g:=0;
    for i:=0 to nk[0]-1 do
    begin
      while i1>=0 do if kv[1][i1].y<=kv[0][i].y then i1:=i1-1 else break;
      while i3>=0 do if kv[3][i3].x> kv[0][i].x then i3:=i3-1 else break;

      if i1=nk[1]-1 then gx:=-INF else gx:=kv[1][i1+1].x;
      if i3<0 then gy:=-INF else gy:=kv[3][i3].y;

      while i2g<nk[2] do if kv[2][i2g].y>gy then inc(i2g) else break;
      while i2d<i2g do if kv[2][i2d].x<=gx then inc(i2d) else break;
      broj:=broj-(i2g-i2d);
      if i2d=nk[2] then break ;
    end;

    // rotiraj za 90 stupnjeva
    temp:=kv[3];
    kv[3]:=kv[2];
    kv[2]:=kv[1];
    kv[1]:=kv[0];
    kv[0]:=temp;
    tempi:=nk[3];
    nk[3]:=nk[2];
    nk[2]:=nk[1];
    nk[1]:=nk[0];
    nk[0]:=tempi;
    for i:=0 to 3 do
       for j:=0 to nk[i]-1 do
       begin
          tempi := kv[i][j].x;
          kv[i][j].x:=-kv[i][j].y;
          kv[i][j].y:= tempi;
       end;
  end;

  // ubaci novu tocku, nema tocaka sa istom x ili y koordinatom
  i:=k;
  while i>0 do
  begin
    if (tox[i-1].x>0)then
      tox[i]:=tox[i-1]
    else
      break ;
     dec(i);
  end;
  tox[i].x:=0;
  tox[i].y:=0;

  i:=k;
  while (i>0) do
  begin
    if (toy[i-1].y>0)then
      toy[i]:=toy[i-1]
    else
      break ;
    dec(i);
  end;
  toy[i].x:=0;
  toy[i].y:=0;
end;

begin
  readln(n);
  broj:=0;
  xx:=0;
  yy:=0;
  for i:=0 to n-1 do
  begin
     readln(x, y);
     dodaj(i, x-xx, y-yy);
     xx:=x;
     yy:=y;
     writeln(broj);
  end;
end.
