
/*
  HIO 2005
  Zadatak ZVRK

  Primijetimo da broj ima zvrk 1 akko je neparan.
  Broj ima zvrk 2 akko pri dijeljenju s 2 postaje neparan.
  U opcem slucaju, broj ima zvrk 2^i akko pri dijeljenju s 2^(i-1) postaje
  neparan.

  Posto mozemo brzo izracunati broj neparnih brojeva u intervalu, u i-toj
  iteraciji dodamo rjesenju taj broj neparnih brojeva puta 2^(i-1). Zatim
  podijelimo granice intervala s 2 (donju granicu zaokruzujemo nagore, a gornju
  nadolje kako bismo se osigurali da nista ne brojimo vise puta).

  Rjesenje je slozenosti theta( log2(B) ). Zanimljivo je da ovaj
  zadatak ima mnogo razlicitih rjesenja, takoder ove slozenosti.
*/

#include <stdio.h>

long long broj_neparnih( long long a, long long b )
{
  if ( a%2 == 0 && b%2 == 0 ) {
    /* paran-paran */
    return ( b-a ) / 2;
  }
  else if ( a%2 == 1 && b%2 == 0 || a%2 == 0 && b%2 == 1 ) {
    /* paran-neparan ili neparan-paran */
    return ( b-a+1 ) / 2;
  }
  else {
    /* neparan-neparan */
    return ( b-a ) / 2 + 1;
  }
}

int main(void)
{
  int i;
  long long a, b, rj = 0;

  scanf( "%lld%lld", &a, &b );
  for ( i=0; b>0; ++i ) {
    rj += broj_neparnih( a, b ) * ( 1LL << i );
    a = (a+1) / 2; b = b / 2;
  }

  printf( "%lld\n", rj );

  return 0;
}
