
(*
  DMIH 2005 - Drugi dan natjecanja
  Srednjoskolska skupina - II. podskupina
  Zadatak LABUDOVI

  Vremenska slozenost: O((R+S)*(R+S))
*)

program labudovi;

const MAXR = 1500;
      MAXS = 1500;
      MAXQ = MAXR*MAXS;
      LED  = 'X';
      VODA = '.';
      PROSAO = '\';
      OTOPITI = '9';

var r, s, dan : longint;
    labr, labs : array[1..2] of integer;
    mapa : array[1..MAXR, 1..MAXS] of char;

    qrL, qsL, qrV, qsV : array[0..MAXQ] of integer;
    qpL, qkL, qpV, qkV : longint;
    stackr, stacks : array[0..MAXQ] of integer;
    sp : longint;


procedure push(r, s : longint; var qr, qs : array of integer; var qp : longint);
begin
   qr[qp]:=r; qs[qp]:=s;
   if qp<MAXQ then qp:=qp+1 else qp:=0;
end;
procedure pop(var r, s : longint; var qr, qs : array of integer; var qk : longint);
begin
   r:=qr[qk]; s:=qs[qk];
   if qk<MAXQ then qk:=qk+1 else qk:=0;
end;

procedure putL(re, st : longint);
begin
   if (re<0)or(re>r)or(st<0)or(st>s)or(mapa[re, st]<>LED) then exit;
   push(re, st, qrL, qsL, qpL);
   mapa[re, st]:=OTOPITI;
end;

procedure putV(re, st : longint);
begin
   if (re<0)or(re>r)or(st<0)or(st>s)or(mapa[re, st]<>VODA) then exit;
   push(re, st, qrV, qsV, qpV);
   mapa[re, st]:=PROSAO;
end;

function granica(re, st : longint) : boolean;
begin
   granica:=false;
   if re>0 then if (mapa[re-1, st]=LED)or(mapa[re-1, st]=OTOPITI) then granica:=true;
   if re<r then if (mapa[re+1, st]=LED)or(mapa[re+1, st]=OTOPITI) then granica:=true;
   if st>0 then if (mapa[re, st-1]=LED)or(mapa[re, st-1]=OTOPITI) then granica:=true;
   if st<s then if (mapa[re, st+1]=LED)or(mapa[re, st+1]=OTOPITI) then granica:=true;
end;

procedure rijesi;
var i, j, qpL_old : longint;
begin
   sp:=0;
   qpL:=0; qkL:=0;
   qpV:=0; qkV:=0;
   for i:=1 to r do
      for j:=1 to s do if mapa[i, j]=VODA then
      begin
         putL(i+1, j);
         putL(i-1, j);
         putL(i, j-1);
         putL(i, j+1);
      end;
   dan:=0;
   putV(labr[1], labs[1]);
   repeat
      //TRAZI LABUDA
      repeat
         pop(i, j, qrV, qsV, qkV);
         if granica(i, j) then   // DODAJ ELEMENT GRANICE U STACK
         begin
            stackr[sp]:=i;
            stacks[sp]:=j;
            sp:=sp+1;
         end;
         if (i=labr[2])and(j=labs[2]) then
         begin
            writeln(dan);  // **** ISPIS RJESENJA ****
            exit;
         end;
         putV(i+1, j);
         putV(i-1, j);
         putV(i, j-1);
         putV(i, j+1);
      until qpV=qkV;
      while sp>0 do  //PREBACI GRANICU IZ STACKA U Q
      begin
         sp:=sp-1;
         push(stackr[sp], stacks[sp], qrV, qsV, qpV);
      end;
      //OTOPI LED
      dan:=dan+1;
      qpL_old:=qpL;
      while (qkL<>qpL_old) do
      begin
         pop(i, j, qrL, qsL, qkL);
         mapa[i, j]:=VODA;
         putL(i+1, j);
         putL(i-1, j);
         putL(i, j-1);
         putL(i, j+1);
      end;
   until false;
end;

procedure ucitaj;
var i, j, koji : longint;
    c : char;
begin
   readln(r, s);
   koji:=1;
   for i:=1 to r do
   begin
      for j:=1 to s do
      begin
         read(c);
         if c='L' then
         begin
            labr[koji]:=i;
            labs[koji]:=j;
            koji:=koji+1;
            c:=VODA;
         end;
         mapa[i, j]:=c;
      end;
      readln;
   end;
end;

begin
   ucitaj;
   rijesi;
end.
