
/*
  DMIH 2005 - Drugi dan natjecanja
  Srednjoskolska skupina - II. podskupina
  Zadatak UTRKA

  Obradjujemo dogadjaje kako nam dolaze i pri tome odrzavamo stanje vozaca o
  kojem dobivamo obavijest.

  Jedno potpuno stanje je:
  - broj kontrolnih tocaka koje je vozac prosao
  - koji od D dogadjaja je zadnji o tom vozacu

  Na pocetku su svi vozaci u stanju (0,-1).

  Sad za svaki i dogadjaj oblika "vozac X prolazi checkpoint Y":
  - ako je Y upravo sljedeca tocka kojom vozac X treba proci
  - postavi zadnji dogadjaj vozaca na i
  - povecaj broj tocaka koje je prosao vozac

  Preostaje nam jos sortirati vozace po stanjima:
  Vozac A je ispred B ako:
  - je prosao vise kontrolnih tocaka
  - su prosli jednak broj tocaka, ali je vozac A prije prosao zadnju tocku
*/

#include <algorithm>
#include <cstdio>

using namespace std;

#define MAXN 100

struct stanje {
  int tocaka, kad_zadnja, indeks;

  friend inline bool operator< ( const stanje &lhs, const stanje &rhs ) {
    if ( lhs.tocaka != rhs.tocaka  ) return lhs.tocaka > rhs.tocaka;
    return lhs.kad_zadnja < rhs.kad_zadnja;
  }
};

int main()
{
  static stanje vozac[MAXN+1];
  int k, n, d;
  scanf( "%d%d%d", &k, &n, &d );

  for ( int i=1; i<=n; ++i ) {
    vozac[i].tocaka     = 0;
    vozac[i].kad_zadnja = -1;
    vozac[i].indeks     = i;
  }

  for ( int i=0; i<d; ++i ) {
    int v, t;
    scanf( "%d%d", &v, &t );
    if ( t == vozac[v].tocaka%k + 1 ) {
      vozac[v].tocaka++;
      vozac[v].kad_zadnja = i;
    }
  }

  sort( vozac+1, vozac+n+1 );

  for ( int i=1; i<=n; ++i )
    printf( "%d%c", vozac[i].indeks, i<n?' ':'\n' );

  return 0;
}
