
(*
  DMIH 2005 - Prvi dan natjecanja
  Srednjoskolska skupina - I. podskupina
  Zadatak AUTOPUT

  Zadatak rjesavamo metodom dinamickog programiranja i to tako da nam stanje
  t(K, X) oznacava najmanje moguce vrijeme da dodjemo do pozicije X ako smo do
  sada izgradili tocno K tunela ili vijadukta.

  Neka desno(X) oznacava prvu poziciju desno od pozicije X iste visine kao i ona.

  Tada iz stanja t(K, X) mozemo izracunati moguce vrijednosti za stanja:
    t(K, X+1)        - ako prodjemo polje bez tunela ili vijadukta
    t(K+1, desno(X)) - ako sagradimo tunel ili vijadukt od pozicije X do desno(X)

  Primjetimo da nam je, ako racunamo po retcima, dovoljno pamtiti samo dva retka
  (K-ti i (K+1)-ti redak) tablice t, buduci da nemamo dovoljno memorije za
  pamtiti cijelu tablicu.
*)

program autoput;

const inf : longint = 1000000000;

function min(a, b: longint): longint;
begin
    if a < b then
        min := a
    else
        min := b;
end;

var
    A, B, C, N, M: longint;
    visina, desno: array[0..100000] of longint;
    zadnja: array[0..100000] of longint;
    minh, maxh: longint;
    ch: Char;
    i, k, x, cur, nxt: longint;
    t: array[0..1, 0..100000] of longint;
    rjesenje: longint;

begin
    minh := 0; maxh := 0;
    for i := 0 to 100000 do
    begin
        visina[i] := 0;
        desno[i] := -1;
        zadnja[i] := -1;
        t[0, i] := inf;
        t[1, i] := inf;
    end;

    readln(A, B, C, N, M);
    for i := 1 to N do
    begin
        read(ch);
        if ch = 'D' then visina[i] := visina[i-1] - 1;
        if ch = 'R' then visina[i] := visina[i-1];
        if ch = 'G' then visina[i] := visina[i-1] + 1;
        if visina[i] < minh then minh := visina[i];
        if visina[i] > maxh then maxh := visina[i];
    end;

    for i := 0 to N do visina[i] := visina[i] - minh;

    for i := 0 to N do
    begin
        if((i > 0) and (visina[i] <> visina[i-1]) and (zadnja[visina[i]] <> -1)) then
            desno[zadnja[visina[i]]] := i;
        zadnja[visina[i]] := i;
    end;

    t[0, 0] := 0;
    rjesenje := inf;
    for k := 0 to M do
    begin
        cur := k mod 2;
        nxt := (k + 1) mod 2;

        for x := 0 to N do t[nxt, x] := inf;
        for x := 0 to N - 1 do
        begin
            if visina[x+1] = visina[x]  then t[cur, x+1] := min(t[cur, x+1], t[cur, x] + A);
            if visina[x+1] <> visina[x] then t[cur, x+1] := min(t[cur, x+1], t[cur, x] + B);

            if desno[x] <> -1 then t[nxt, desno[x]] := min(t[nxt, desno[x]], t[cur, x] + C*(desno[x]-x));
        end;

        rjesenje := min(rjesenje, t[cur, N]);
    end;

    writeln(rjesenje);
end.
