
(*
  DMIH 2005 - Prvi dan natjecanja
  Srednjoskolska skupina - I. podskupina
  Zadatak ZMIJA

  Zadatak rjesavamo simulacijom pravila danih u tekstu zadatka. Matrica 'mapa' 
  nam za svako polje (r, s) govori kad je zadnji put zmijina glava bila na tom 
  polju.
  Svake sekunde obavimo sljedece radnje:

  1. Pomaknemo glavu zmije u trenutnom smjeru
  2. Ako se u zmija okrenula u ovoj sekundi, oznacimo promjenu smjera
  3. Ako je zmija izasla izvan granica polja, kraj
  4. Ako se na trenutnom mjestu glave nalazila glava prije (vrijeme-duljina)
    sekundi ili kasnije, zmija je udarila samu sebe - kraj
  5. Ako se na mjestu glave nalazi jabuka, povecamo duljinu za 1
  6. Povecamo vrijeme za 1 i zapisemo ga u mapu
*)

program zmija;

const MAXN   = 100;
      MAXV   = 10000;
      JABUKA = -1;

      pr : array[1..4] of longint = (-1, 0, 1, 0);
      ps : array[1..4] of longint = (0, 1, 0, -1);

var n, k, l, x : longint;
    c : char;
    r, s, vrijeme : longint;
    mapa : array[1..MAXN, 1..MAXN] of longint;
    akcije : array[1..MAXV] of char;

procedure okreni(sm : longint);
begin
   x:=x+sm;
   if x=0 then x:=4;
   if x=5 then x:=1;
end;

begin
   readln(n);
   for r:=1 to n do
      for s:=1 to n do mapa[r, s]:=0;
   readln(k);
   while k>0 do
   begin
      readln(r, s);
      mapa[r, s]:=JABUKA;
      k:=k-1;
   end;
   for x:=1 to MAXV do akcije[x]:='-';
   readln(l);
   while l>0 do
   begin
      readln(x, c, c); // moramo procitati i jedan razmak!
      akcije[x]:=c;
      l:=l-1;
   end;
   r:=1;                               // glava zmije
   s:=1;                               // glava zmije
   l:=1;                               // duljina zmije
   vrijeme:=1;
   if mapa[r, s]=JABUKA then l:=l+1;
   x:=2;                               // smjer - desno
   mapa[r, s]:=vrijeme;                // stvori zmiju!
   repeat
      r:=r+pr[x];                      // pomakni glavu
      s:=s+ps[x];                      // pomakni glavu
      if akcije[vrijeme]='L' then okreni(-1) else
         if akcije[vrijeme]='D' then okreni(1);
      if (r<1)or(r>n)or(s<1)or(s>n) then break;
      if (mapa[r, s]>0)and(mapa[r, s]>vrijeme-l) then break;
      if mapa[r, s]=JABUKA then l:=l+1;
      vrijeme:=vrijeme+1;              // vrijeme ide...
      mapa[r, s]:=vrijeme;             // stvori glavu
   until false;
   writeln(vrijeme);
end.
