#include <list>
#include <queue>
#include <cstdio>
#include <vector>
#include <string>
#include <cassert>
#include <cstring>
#include <iterator>
#include <iostream>
#include <algorithm>

#define OK(x) ((x) >= 0 && (x) < 3)

using namespace std;

const int dx[4] = {0, -1, 0, 1};
const int dy[4] = {1, 0, -1, 0};
const int maxh = 362880;
const int fact[10] = {1, 1, 2, 6, 24, 120, 720, 5040, 40320};

// O(n^2)

int hash_helper(const char *m) {
  int bio[9] = {0}, ret = 0;
  for (int i = 0; i < 9; ++i) {
    for (int j = 0; j < m[i]; ++j)
      if (!bio[j]) ret += fact[9 - i - 1];
    bio[(int) m[i]] = 1;
  }
  return ret;
}

struct state {
  char map[3][3];
  int hash;

  state(FILE *in) {
    string t;
    assert(in);
    for (int i = 0; i < 3; ++i)
      for (int j = 0; j < 3; ++j) {
        cin >> t;
        map[i][j] = (t[0] == 'X' ? 8 : t[0] - '1');
      }
    hash = hash_helper(map[0]);
  }

  state(const state &rhs, int sm, int *wh) : hash(rhs.hash) {
    int mx, my, rx, ry;
    memcpy(map, rhs.map, sizeof map);
    find_empty(&mx, &my);
    rx = mx + dx[sm], ry = my + dy[sm];
    if (OK(rx) && OK(ry)) {
      swap(map[mx][my], map[rx][ry]);
      hash = hash_helper(map[0]);
      *wh = map[mx][my];
    } else {
      *wh = -1;
    }
  }

  void find_empty(int *mx, int *my) const {
    for (int i = 0; i < 3; ++i)
      for (int j = 0; j < 3; ++j)
        if (map[i][j] == 8)
          *mx = i, *my = j;
  }
};

int bio[maxh], parent[maxh], what[maxh];
queue<state> q;

void enqueue_next(const state &s) {
  int wh;
  for (int sm = 0; sm < 4; ++sm) {
    state cpy(s, sm, &wh);
    if (wh != -1 && bio[cpy.hash] == -1) {
      bio[cpy.hash] = bio[s.hash] + 1;
      parent[cpy.hash] = s.hash;
      what[cpy.hash] = wh;
      q.push(cpy);
    }
  }
}

void reconstruct(const state &start, const state &end) {
  list<int> sol;
  for (int it = end.hash; it != start.hash; it = parent[it]) {
    sol.push_back(what[it] + 1);
  }
  cout << sol.size() << endl;
  copy(sol.rbegin(), sol.rend(), ostream_iterator<int>(cout, " "));
  cout << endl;
  exit(0);
}

int bfs(const state &start) {
  memset(bio, -1, sizeof bio);
  bio[start.hash] = 0;
  for (q.push(start); q.size(); q.pop()) {
    q.front().hash ?
      enqueue_next(q.front())
      : reconstruct(start, q.front());
  }
  return -1;
}

int main() {
  state start(stdin);
  if (bfs(start) == -1) {
    cout << "nema rjesenja" << endl;
  }
  return 0;
}
