#include <cstdio>
#include <cstring>
#include <utility>

typedef unsigned long long llint;

const int maxn = 32;

llint factorials[maxn];
char left[maxn], right[maxn];

llint factorial(int n) {
  if (factorials[n]) return factorials[n];
  return factorials[n] = n ? n * factorial(n - 1) : 1;
}

llint solve(int n, char *a) {
  static char bio[maxn];
  memset(bio, 0, sizeof bio);
  for (int i = 0; i < n; ++i)
    a[i] -= 'a';

  llint ret = 0;
  for (int i = 0; i < n; bio[(int) a[i++]] = 1) {
    for (int j = 0; j < a[i]; ++j)
      if (!bio[j])
        ret += factorial(n - i - 1);
  }
  return ret;
}

int main() {
  int N;
  scanf("%d", &N);
  scanf("%s%s", left, right);
  if (strcmp(left, right) > 0) std::swap(left, right);
  printf("%llu\n", solve(N, right) - solve(N, left));
  return 0;
}
