// k je prosjecna duljina rijeci
// n je broj rijeci
// k n log n
//
#include <cstdio>
#include <vector>
#include <string>
#include <iostream>
#include <algorithm>

using namespace std;

typedef vector<string> rijec;
vector<rijec> rijecnik;

bool operator< (const rijec &a, const rijec &b) {
  for (size_t it = 0; it < std::min(a.size(), b.size()); ++it)
    if (a[it] != b[it])
      return a[it] < b[it];
  return false;
}

rijec input(const string &t) {
  rijec sol;
  for (size_t it = 0; it < t.size(); ++it)
    if ((t[it] == 'l' || t[it] == 'n') && it + 1 < t.size() && t[it + 1] == 'j')
      sol.push_back(t.substr(it++, 2));
    else
      sol.push_back(t.substr(it, 1));
  sol.push_back("0");
  return sol;
}

void print(const rijec &t) {
  for (size_t it = 0; it < t.size() - 1; ++it)
    cout << t[it];
  cout << endl;
}

int main() {
  string t;
  cin >> t; // ignore first word (number of words)
  for (; cin >> t; rijecnik.push_back(input(t)));
  sort(rijecnik.begin(), rijecnik.end());
  for (size_t it = 0; it < rijecnik.size(); print(rijecnik[it++]));
  return 0;
}
